/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.config.SystemConfig;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.properties.WechatValue;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.wechat.pay.contrib.apache.httpclient.Credentials;
import com.wechat.pay.contrib.apache.httpclient.Validator;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.PrivateKeySigner;
import com.wechat.pay.contrib.apache.httpclient.auth.Signer;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Credentials;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import com.wechat.pay.contrib.apache.httpclient.cert.CertificatesManager;
import com.wechat.pay.contrib.apache.httpclient.exception.ParseException;
import com.wechat.pay.contrib.apache.httpclient.exception.ValidationException;
import com.wechat.pay.contrib.apache.httpclient.notification.Notification;
import com.wechat.pay.contrib.apache.httpclient.notification.NotificationHandler;
import com.wechat.pay.contrib.apache.httpclient.notification.NotificationRequest;
import com.wechat.pay.contrib.apache.httpclient.notification.Request;
import com.wechat.pay.contrib.apache.httpclient.util.AesUtil;
import com.wechat.pay.contrib.apache.httpclient.util.PemUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;

public class PayUtil {
    private static volatile PrivateKey PRIVATE_KEY;
    private static final Logger log;

    private PayUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PrivateKey privateKeyInstance() {
        if (PRIVATE_KEY != null) return PRIVATE_KEY;
        Class<PayUtil> clazz = PayUtil.class;
        synchronized (PayUtil.class) {
            if (PRIVATE_KEY != null) return PRIVATE_KEY;
            FileSystemResource resourcePrivateKey = new FileSystemResource(new File(SystemConfig.APP.getWechat().getPrivateKeyPath()));
            try (InputStream is = resourcePrivateKey.getInputStream();){
                PRIVATE_KEY = PemUtil.loadPrivateKey((InputStream)is);
            }
            catch (Exception e) {
                log.error("\u52a0\u8f7d\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff01", (Throwable)e);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return PRIVATE_KEY;
        }
    }

    public static CloseableHttpClient httpClient() {
        WechatValue wechat = SystemConfig.APP.getWechat();
        CloseableHttpClient client = null;
        try {
            PrivateKey privateKey = PayUtil.privateKeyInstance();
            String mchId = wechat.getMchId();
            String mchSerialNo = wechat.getMchSerialNo();
            Verifier verifier = PayUtil.verifier(wechat);
            client = WechatPayHttpClientBuilder.create().withMerchant(mchId, mchSerialNo, privateKey).withValidator((Validator)new WechatPay2Validator(verifier)).build();
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u8bc1\u4e66\u5931\u8d25\uff01", (Throwable)e);
            e.printStackTrace();
        }
        return client;
    }

    public static boolean signVerify(HttpServletRequest request, String body) throws ValidationException, ParseException {
        String timestamp = request.getHeader("Wechatpay-Timestamp");
        String nonce = request.getHeader("Wechatpay-Nonce");
        String signature = request.getHeader("Wechatpay-Signature");
        String serial = request.getHeader("Wechatpay-Serial");
        log.info("\u652f\u4ed8\u56de\u8c03\u53c2\u6570\uff0c{}, {}, {}, {}", new Object[]{timestamp, nonce, signature, serial});
        WechatValue wechat = SystemConfig.APP.getWechat();
        NotificationRequest notificationRequest = new NotificationRequest.Builder().withSerialNumber(serial).withNonce(nonce).withTimestamp(timestamp).withSignature(signature).withBody(body).build();
        Verifier verifier = PayUtil.verifier(wechat);
        NotificationHandler handler = new NotificationHandler(verifier, wechat.getApiV3Key().getBytes(StandardCharsets.UTF_8));
        Notification notification = handler.parse((Request)notificationRequest);
        return notification != null;
    }

    private static Verifier verifier(WechatValue wechat) {
        CertificatesManager certificates = CertificatesManager.getInstance();
        PrivateKey privateKey = PayUtil.privateKeyInstance();
        String mchId = wechat.getMchId();
        try {
            certificates.putMerchant(mchId, (Credentials)new WechatPay2Credentials(mchId, (Signer)new PrivateKeySigner(wechat.getMchSerialNo(), privateKey)), wechat.getApiV3Key().getBytes(StandardCharsets.UTF_8));
            return certificates.getVerifier(mchId);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8bc1\u4e66\u9a8c\u8bc1\u5668\u5931\u8d25\uff01", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u8bc1\u4e66\u9a8c\u8bc1\u5668\u5931\u8d25\uff01");
        }
    }

    public static <T> T post(String url, Object params, Class<T> clazz) {
        String result;
        block18: {
            HttpPost post = new HttpPost(url);
            post.setHeader("Accept", "application/json");
            post.setHeader("Content-Type", "application/json; charset=utf-8");
            String json = JsonUtil.toJson((Object)params);
            if (json == null) {
                return null;
            }
            result = null;
            post.setEntity((HttpEntity)new StringEntity(json, StandardCharsets.UTF_8));
            try (CloseableHttpClient client = PayUtil.httpClient();
                 CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                int code = response.getStatusLine().getStatusCode();
                if (code == 200) {
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                    break block18;
                }
                if (code == 204) {
                    result = "{}";
                    break block18;
                }
                throw new CavException("BIZ000100010");
            }
            catch (Exception e) {
                log.error("\u5fae\u4fe1\u652f\u4ed8\u8bf7\u6c42\u5931\u8d25\uff01", (Throwable)e);
            }
        }
        if (clazz == String.class) {
            return (T)PojoUtil.cast(result);
        }
        return (T)JsonUtil.toPojo(result, clazz);
    }

    public static String decryptOrder(String body) {
        WechatValue wechat = SystemConfig.APP.getWechat();
        try {
            AesUtil aesUtil = new AesUtil(wechat.getApiV3Key().getBytes(StandardCharsets.UTF_8));
            JsonNode node = JsonUtil.toNode((Serializable)((Object)body));
            JsonNode resource = node.get("resource");
            String ciphertext = resource.get("ciphertext").textValue();
            String associatedData = resource.get("associated_data").textValue();
            String nonce = resource.get("nonce").textValue();
            return aesUtil.decryptToString(associatedData.getBytes(StandardCharsets.UTF_8), nonce.getBytes(StandardCharsets.UTF_8), ciphertext);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    static {
        log = LoggerFactory.getLogger(PayUtil.class);
    }
}

