/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.vo.request;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
* 请求微信支付接口请求封装对象
 * 金额
* @Author: xyb
* @Description: 
* @Date: 2023-03-24 下午 09:46
**/
public class OrderRefundAmountFrom {

    /** 出资金额 */
    @JsonProperty(value = "amount")
    private int amount;
    /** 出资账户类型 */
    @JsonProperty(value = "account")
    private String account;

    /**
     * 获取 出资金额
     *
     * @return amount 出资金额
     */
    public int getAmount() {
        return this.amount;
    }

    /**
     * 设置 出资金额
     *
     * @param amount 出资金额
     */
    public void setAmount(int amount) {
        this.amount = amount;
    }

    /**
     * 获取 出资账户类型
     *
     * @return account 出资账户类型
     */
    public String getAccount() {
        return this.account;
    }

    /**
     * 设置 出资账户类型
     *
     * @param account 出资账户类型
     */
    public void setAccount(String account) {
        this.account = account;
    }
}
