/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.vo.request;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
* 请求微信支付接口请求封装对象
 * 金额
* @Author: xyb
* @Description: 
* @Date: 2023-03-24 下午 09:46
**/
public class OrderPaymentDetailAmount {
    /**
     * 订单总金额，单位为分
     */
    @JsonProperty(value = "total")
    private int total;
    /**
     * 用户支付金额，单位为分
     */
    @JsonProperty(value = "payer_total")
    private int payerTotal;
    /**
     * CNY：人民币，境内商户号仅支持人民币。
     */
    @JsonProperty(value = "currency")
    private String currency;
    /**
     * CNY：人民币，用户支付币种。
     */
    @JsonProperty(value = "payer_currency")
    private String payerCurrency;

    /**
     * 获取 订单总金额，单位为分
     *
     * @return total 订单总金额，单位为分
     */
    public int getTotal() {
        return this.total;
    }

    /**
     * 设置 订单总金额，单位为分
     *
     * @param total 订单总金额，单位为分
     */
    public void setTotal(int total) {
        this.total = total;
    }

    /**
     * 获取 用户支付金额，单位为分
     *
     * @return payerTotal 用户支付金额，单位为分
     */
    public int getPayerTotal() {
        return this.payerTotal;
    }

    /**
     * 设置 用户支付金额，单位为分
     *
     * @param payerTotal 用户支付金额，单位为分
     */
    public void setPayerTotal(int payerTotal) {
        this.payerTotal = payerTotal;
    }

    /**
     * 获取 CNY：人民币，境内商户号仅支持人民币。
     *
     * @return currency CNY：人民币，境内商户号仅支持人民币。
     */
    public String getCurrency() {
        return this.currency;
    }

    /**
     * 设置 CNY：人民币，境内商户号仅支持人民币。
     *
     * @param currency CNY：人民币，境内商户号仅支持人民币。
     */
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    /**
     * 获取 CNY：人民币，用户支付币种。
     *
     * @return payerCurrency CNY：人民币，用户支付币种。
     */
    public String getPayerCurrency() {
        return this.payerCurrency;
    }

    /**
     * 设置 CNY：人民币，用户支付币种。
     *
     * @param payerCurrency CNY：人民币，用户支付币种。
     */
    public void setPayerCurrency(String payerCurrency) {
        this.payerCurrency = payerCurrency;
    }
}

