/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.vo.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;

/**
 * 微信支付回调接口响应封装对象
 * @Author: xyb
 * @Description: 
 * @Date: 2023-03-24 下午 10:52
 **/
public class PaymentCallbackResponse implements Serializable {

	/** SUCCESS/FAIL*/
    @Schema(description = "SUCCESS/FAIL")
    @JsonProperty(value = "code")
    private String code;
    /**若失败则为异常信息*/
    @Schema(description = "若失败则为异常信息")
    @JsonProperty(value = "message")
    private String message;

    /**
     * 获取 SUCCESSFAIL
     *
     * @return code SUCCESSFAIL
     */
    public String getCode() {
        return this.code;
    }

    /**
     * 设置 SUCCESSFAIL
     *
     * @param code SUCCESSFAIL
     */
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 获取 若失败则为异常信息
     *
     * @return message 若失败则为异常信息
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * 设置 若失败则为异常信息
     *
     * @param message 若失败则为异常信息
     */
    public void setMessage(String message) {
        this.message = message;
    }
}
