/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.service.impl;

import cn.sinozg.applet.biz.system.service.TencentCbService;
import cn.sinozg.applet.biz.system.service.TencentService;
import cn.sinozg.applet.biz.system.vo.request.TencentMessageRequest;
import cn.sinozg.applet.biz.system.vo.request.TencentServiceRequest;
import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.utils.CypherUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import jakarta.annotation.Resource;

/**
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-23 下午 05:49
 **/
@Service
public class TencentServiceImpl implements TencentService {


    @Resource
    private AppValue app;

    @Resource
    private TencentCbService service;

    private final Logger log = LoggerFactory.getLogger(TencentServiceImpl.class);
    @Override
    public String receiveGet(TencentServiceRequest params) {
        log.info("get receive signature {}, timestamp {} , nonce {}, , echostr {}", params.getSignature(), params.getTimestamp()
                , params.getNonce(), params.getEchostr());
        boolean success = CypherUtil.signature(false, params.getSignature(), params.getTimestamp(), params.getNonce(), app.getWechat().getMsgToken());
        return success ? params.getEchostr() : StringUtils.EMPTY;
    }

    @Override
    public TencentMessageRequest receivePost(TencentMessageRequest params) {
        return service.wechatMessage(params);
    }
}