/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.vo.response;

import com.fasterxml.jackson.annotation.JsonProperty;


/**
 * 请求微信支付接口返回封装对象
 * @Author: xyb
 * @Description: 
 * @Date: 2023-04-06 下午 09:48
 **/
public class OrderPaymentResponse {
    /** 预支付交易会话标识 */
    @JsonProperty(value = "prepay_id")
    private String prepayId;

    /**
     * 获取 预支付交易会话标识
     *
     * @return prepayId 预支付交易会话标识
     */
    public String getPrepayId() {
        return this.prepayId;
    }

    /**
     * 设置 预支付交易会话标识
     *
     * @param prepayId 预支付交易会话标识
     */
    public void setPrepayId(String prepayId) {
        this.prepayId = prepayId;
    }
}
