/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.vo.response;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 微信退款返回返回封装对象
 * @Author: xyb
 * @Description: 
 * @Date: 2023-04-06 下午 09:48
 **/
public class OrderRefundResponse {
    /**
     * 微信支付退款单号
     */
    @JsonProperty(value = "refund_id")
    private String refundId;
    /**
     * 商户退款单号
     */
    @JsonProperty(value = "out_refund_no")
    private String outRefundNo;
    /**
     * 微信支付订单号
     */
    @JsonProperty(value = "transaction_id")
    private String transactionId;
    /**
     * 商户订单号
     */
    @JsonProperty(value = "out_trade_no")
    private String outTradeNo;
    /**
     * 退款渠道
     */
    @JsonProperty(value = "channel")
    private String channel;
    /**
     * 退款入账账户
     */
    @JsonProperty(value = "user_received_account")
    private String userReceivedAccount;
    /**
     * 退款成功时间
     */
    @JsonProperty(value = "success_time")
    private String successTime;
    /**
     * 退款创建时间
     */
    @JsonProperty(value = "create_time")
    private String createTime;
    /**
     * 退款状态
     */
    @JsonProperty(value = "status")
    private String status;
    /**
     * 资金账户
     */
    @JsonProperty(value = "funds_account")
    private String fundsAccount;
    /**
     * amount
     */
    @JsonProperty(value = "amount")
    private OrderRefundResponseAmount amount;

    /**
     * 获取 微信支付退款单号
     *
     * @return refundId 微信支付退款单号
     */
    public String getRefundId() {
        return this.refundId;
    }

    /**
     * 设置 微信支付退款单号
     *
     * @param refundId 微信支付退款单号
     */
    public void setRefundId(String refundId) {
        this.refundId = refundId;
    }

    /**
     * 获取 商户退款单号
     *
     * @return outRefundNo 商户退款单号
     */
    public String getOutRefundNo() {
        return this.outRefundNo;
    }

    /**
     * 设置 商户退款单号
     *
     * @param outRefundNo 商户退款单号
     */
    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    /**
     * 获取 微信支付订单号
     *
     * @return transactionId 微信支付订单号
     */
    public String getTransactionId() {
        return this.transactionId;
    }

    /**
     * 设置 微信支付订单号
     *
     * @param transactionId 微信支付订单号
     */
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    /**
     * 获取 商户订单号
     *
     * @return outTradeNo 商户订单号
     */
    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    /**
     * 设置 商户订单号
     *
     * @param outTradeNo 商户订单号
     */
    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    /**
     * 获取 退款渠道
     *
     * @return channel 退款渠道
     */
    public String getChannel() {
        return this.channel;
    }

    /**
     * 设置 退款渠道
     *
     * @param channel 退款渠道
     */
    public void setChannel(String channel) {
        this.channel = channel;
    }

    /**
     * 获取 退款入账账户
     *
     * @return userReceivedAccount 退款入账账户
     */
    public String getUserReceivedAccount() {
        return this.userReceivedAccount;
    }

    /**
     * 设置 退款入账账户
     *
     * @param userReceivedAccount 退款入账账户
     */
    public void setUserReceivedAccount(String userReceivedAccount) {
        this.userReceivedAccount = userReceivedAccount;
    }

    /**
     * 获取 退款成功时间
     *
     * @return successTime 退款成功时间
     */
    public String getSuccessTime() {
        return this.successTime;
    }

    /**
     * 设置 退款成功时间
     *
     * @param successTime 退款成功时间
     */
    public void setSuccessTime(String successTime) {
        this.successTime = successTime;
    }

    /**
     * 获取 退款创建时间
     *
     * @return createTime 退款创建时间
     */
    public String getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置 退款创建时间
     *
     * @param createTime 退款创建时间
     */
    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取 退款状态
     *
     * @return status 退款状态
     */
    public String getStatus() {
        return this.status;
    }

    /**
     * 设置 退款状态
     *
     * @param status 退款状态
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * 获取 资金账户
     *
     * @return fundsAccount 资金账户
     */
    public String getFundsAccount() {
        return this.fundsAccount;
    }

    /**
     * 设置 资金账户
     *
     * @param fundsAccount 资金账户
     */
    public void setFundsAccount(String fundsAccount) {
        this.fundsAccount = fundsAccount;
    }

    /**
     * 获取 amount
     *
     * @return amount amount
     */
    public OrderRefundResponseAmount getAmount() {
        return this.amount;
    }

    /**
     * 设置 amount
     *
     * @param amount amount
     */
    public void setAmount(OrderRefundResponseAmount amount) {
        this.amount = amount;
    }
}
