/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.service;


import cn.sinozg.applet.biz.system.vo.request.TencentMessageRequest;
import cn.sinozg.applet.biz.system.vo.request.TencentServiceRequest;

/**
 * 腾讯验证接口
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-23 下午 05:43
 **/
public interface TencentService {

    /**
     * 腾讯接口验证
     * @param params 服务器传过来的参数
     * @return 返回信息
     */
    String receiveGet(TencentServiceRequest params);

    /**
     * 腾讯接口消息接收
     * @param params 服务器传过来的参数
     * @return 返回给服务器的结果
     */
    TencentMessageRequest receivePost(TencentMessageRequest params);
}
