/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.vo.request;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 请求微信支付接口请求封装对象
 * @Author: xyb
 * @Description: 
 * @Date: 2023-05-03 下午 01:45
 **/
public class OrderPaymentRequest {
    /** 小程序ID */
    @JsonProperty(value = "appid")
    private String appId;
    /** 商户号 */
    @JsonProperty(value = "mchid")
    private String mchId;
    /** 通知地址 */
    @JsonProperty(value = "notify_url")
    private String notifyUrl;
    /** 商品描述 */
    @JsonProperty(value = "description")
    private String description;

    /** 商户订单号 */
    @JsonProperty(value = "out_trade_no")
    private String outTradeNo;
    /** 金额 */
    @JsonProperty(value = "amount")
    private OrderPaymentAmount amount;
    /** 支付者信息 */
    @JsonProperty(value = "payer")
    private OrderPaymentPayer payer;
    /** 场景信息 */
    @JsonProperty(value = "scene_info")
    private OrderPaymentScene scene;

    /**
     * 获取 小程序ID
     *
     * @return appId 小程序ID
     */
    public String getAppId() {
        return this.appId;
    }

    /**
     * 设置 小程序ID
     *
     * @param appId 小程序ID
     */
    public void setAppId(String appId) {
        this.appId = appId;
    }

    /**
     * 获取 商户号
     *
     * @return mchId 商户号
     */
    public String getMchId() {
        return this.mchId;
    }

    /**
     * 设置 商户号
     *
     * @param mchId 商户号
     */
    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    /**
     * 获取 通知地址
     *
     * @return notifyUrl 通知地址
     */
    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    /**
     * 设置 通知地址
     *
     * @param notifyUrl 通知地址
     */
    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    /**
     * 获取 商品描述
     *
     * @return description 商品描述
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * 设置 商品描述
     *
     * @param description 商品描述
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * 获取 商户订单号
     *
     * @return outTradeNo 商户订单号
     */
    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    /**
     * 设置 商户订单号
     *
     * @param outTradeNo 商户订单号
     */
    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    /**
     * 获取 金额
     *
     * @return amount 金额
     */
    public OrderPaymentAmount getAmount() {
        return this.amount;
    }

    /**
     * 设置 金额
     *
     * @param amount 金额
     */
    public void setAmount(OrderPaymentAmount amount) {
        this.amount = amount;
    }

    /**
     * 获取 支付者信息
     *
     * @return payer 支付者信息
     */
    public OrderPaymentPayer getPayer() {
        return this.payer;
    }

    /**
     * 设置 支付者信息
     *
     * @param payer 支付者信息
     */
    public void setPayer(OrderPaymentPayer payer) {
        this.payer = payer;
    }

    /**
     * 获取 场景信息
     *
     * @return scene 场景信息
     */
    public OrderPaymentScene getScene() {
        return this.scene;
    }

    /**
     * 设置 场景信息
     *
     * @param scene 场景信息
     */
    public void setScene(OrderPaymentScene scene) {
        this.scene = scene;
    }
}
