/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.vo.request;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 请求微信支付接口请求封装对象
 * @Author: xyb
 * @Description: 
 * @Date: 2023-03-24 下午 11:57
 **/
public class OrderRefundRequest {

    /** 微信支付订单号*/
    @JsonProperty(value = "transaction_id")
    private String transactionId;

    /** 商户订单号 */
    @JsonProperty(value = "out_trade_no")
    private String outTradeNo;

    /** 商户退款单号 */
    @JsonProperty(value = "out_refund_no")
    private String outRefundNo;
    /** 退款原因 */
    @JsonProperty(value = "reason")
    private String reason;
    /** 退款结果回调url */
    @JsonProperty(value = "notify_url")
    private String notifyUrl;
    /** 退款资金来源 */
    @JsonProperty(value = "funds_account")
    private String fundsAccount;
    /**若失败则为异常信息*/
    @JsonProperty(value = "amount")
    private OrderRefundAmount amount;

    /**
     * 获取 微信支付订单号
     *
     * @return transactionId 微信支付订单号
     */
    public String getTransactionId() {
        return this.transactionId;
    }

    /**
     * 设置 微信支付订单号
     *
     * @param transactionId 微信支付订单号
     */
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    /**
     * 获取 商户订单号
     *
     * @return outTradeNo 商户订单号
     */
    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    /**
     * 设置 商户订单号
     *
     * @param outTradeNo 商户订单号
     */
    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    /**
     * 获取 商户退款单号
     *
     * @return outRefundNo 商户退款单号
     */
    public String getOutRefundNo() {
        return this.outRefundNo;
    }

    /**
     * 设置 商户退款单号
     *
     * @param outRefundNo 商户退款单号
     */
    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    /**
     * 获取 退款原因
     *
     * @return reason 退款原因
     */
    public String getReason() {
        return this.reason;
    }

    /**
     * 设置 退款原因
     *
     * @param reason 退款原因
     */
    public void setReason(String reason) {
        this.reason = reason;
    }

    /**
     * 获取 退款结果回调url
     *
     * @return notifyUrl 退款结果回调url
     */
    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    /**
     * 设置 退款结果回调url
     *
     * @param notifyUrl 退款结果回调url
     */
    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    /**
     * 获取 退款资金来源
     *
     * @return fundsAccount 退款资金来源
     */
    public String getFundsAccount() {
        return this.fundsAccount;
    }

    /**
     * 设置 退款资金来源
     *
     * @param fundsAccount 退款资金来源
     */
    public void setFundsAccount(String fundsAccount) {
        this.fundsAccount = fundsAccount;
    }

    /**
     * 获取 若失败则为异常信息
     *
     * @return amount 若失败则为异常信息
     */
    public OrderRefundAmount getAmount() {
        return this.amount;
    }

    /**
     * 设置 若失败则为异常信息
     *
     * @param amount 若失败则为异常信息
     */
    public void setAmount(OrderRefundAmount amount) {
        this.amount = amount;
    }
}
