/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.service;


import cn.sinozg.applet.biz.system.vo.response.PaymentCallbackDetail;
import cn.sinozg.applet.biz.system.vo.response.RefundCallbackDetail;

/**
 * 框架 服务类，需要项目去具体实现
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-22 下午 02:28
 **/
public interface FrameworkPayService {

    /**
     * 支付回调
     * @param orderId 订单id
     * @param success 是否成功
     * @param params 其他参数
     */
    void paymentCallback (String orderId, boolean success, PaymentCallbackDetail params);

    /**
     * 退款回调
     * @param params 退款参数
     * @return 是否成功
     */
    boolean refundCallback(RefundCallbackDetail params);

}
