/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.service;

import cn.sinozg.applet.biz.system.vo.request.WebPaymentRequest;
import cn.sinozg.applet.biz.system.vo.request.WebRefundRequest;
import cn.sinozg.applet.biz.system.vo.response.OrderRefundResponse;
import cn.sinozg.applet.biz.system.vo.response.PaymentCallbackResponse;

import jakarta.servlet.http.HttpServletRequest;

/**
 * 小程序支付相关的接口
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-22 下午 06:40
 **/
public interface PaymentService {
    /**
     * 申请支付
     * @param param 支付信息
     * @return 支付id
     */
    String payment (WebPaymentRequest param);

    /**
     * 关闭订单
     * @param outTradeNo 订单编号
     * @return 是否成功
     */
    boolean closeOrder (String outTradeNo);

    /**
     * 支付回调
     * @param request HttpServletRequest
     * @return 回调结果
     */
    PaymentCallbackResponse paymentCallback(HttpServletRequest request);

    /**
     * 退款申请
     * @param params 退款请求参数
     * @return 退款返回参数
     */
    OrderRefundResponse refund (WebRefundRequest params);


    /**
     * 退款申请回调
     * @param request HttpServletRequest
     * @return 申请回调结果
     */
    PaymentCallbackResponse refundCallBack(HttpServletRequest request);
}
