/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.vo.response;

import cn.sinozg.applet.biz.system.vo.request.OrderPaymentDetailAmount;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

/**
* 微信退款回调接口响应封装对象
 * 详情
* @Author: xyb
* @Description: 
* @Date: 2023-03-24 下午 10:52
**/
public class RefundCallbackDetail implements Serializable {

    /**  商户号 */
    @JsonProperty(value = "mchid")
    private String mchId;
    /** 微信支付订单号*/
    @JsonProperty(value = "transaction_id")
    private String transactionId;

    /** 商户订单号 */
    @JsonProperty(value = "out_trade_no")
    private String outTradeNo;

    /** 微信支付退款单号 */
    @JsonProperty(value = "refund_id")
    private String refundId;
    /** 退款状态 */
    @JsonProperty(value = "refund_status")
    private String refundStatus;
    /** 交易状态描述 */
    @JsonProperty(value = "trade_state_desc")
    private String tradeStateDesc;
    /** 退款入账账户 */
    @JsonProperty(value = "user_received_account")
    private String userReceivedAccount;
    /** 支付完成时间 */
    @JsonProperty(value = "success_time")
    private String successTime;
    /**若失败则为异常信息*/
    @JsonProperty(value = "amount")
    private OrderPaymentDetailAmount amount;

    /**
     * 获取 商户号
     *
     * @return mchId 商户号
     */
    public String getMchId() {
        return this.mchId;
    }

    /**
     * 设置 商户号
     *
     * @param mchId 商户号
     */
    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    /**
     * 获取 微信支付订单号
     *
     * @return transactionId 微信支付订单号
     */
    public String getTransactionId() {
        return this.transactionId;
    }

    /**
     * 设置 微信支付订单号
     *
     * @param transactionId 微信支付订单号
     */
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    /**
     * 获取 商户订单号
     *
     * @return outTradeNo 商户订单号
     */
    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    /**
     * 设置 商户订单号
     *
     * @param outTradeNo 商户订单号
     */
    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    /**
     * 获取 微信支付退款单号
     *
     * @return refundId 微信支付退款单号
     */
    public String getRefundId() {
        return this.refundId;
    }

    /**
     * 设置 微信支付退款单号
     *
     * @param refundId 微信支付退款单号
     */
    public void setRefundId(String refundId) {
        this.refundId = refundId;
    }

    /**
     * 获取 退款状态
     *
     * @return refundStatus 退款状态
     */
    public String getRefundStatus() {
        return this.refundStatus;
    }

    /**
     * 设置 退款状态
     *
     * @param refundStatus 退款状态
     */
    public void setRefundStatus(String refundStatus) {
        this.refundStatus = refundStatus;
    }

    /**
     * 获取 交易状态描述
     *
     * @return tradeStateDesc 交易状态描述
     */
    public String getTradeStateDesc() {
        return this.tradeStateDesc;
    }

    /**
     * 设置 交易状态描述
     *
     * @param tradeStateDesc 交易状态描述
     */
    public void setTradeStateDesc(String tradeStateDesc) {
        this.tradeStateDesc = tradeStateDesc;
    }

    /**
     * 获取 退款入账账户
     *
     * @return userReceivedAccount 退款入账账户
     */
    public String getUserReceivedAccount() {
        return this.userReceivedAccount;
    }

    /**
     * 设置 退款入账账户
     *
     * @param userReceivedAccount 退款入账账户
     */
    public void setUserReceivedAccount(String userReceivedAccount) {
        this.userReceivedAccount = userReceivedAccount;
    }

    /**
     * 获取 支付完成时间
     *
     * @return successTime 支付完成时间
     */
    public String getSuccessTime() {
        return this.successTime;
    }

    /**
     * 设置 支付完成时间
     *
     * @param successTime 支付完成时间
     */
    public void setSuccessTime(String successTime) {
        this.successTime = successTime;
    }

    /**
     * 获取 若失败则为异常信息
     *
     * @return amount 若失败则为异常信息
     */
    public OrderPaymentDetailAmount getAmount() {
        return this.amount;
    }

    /**
     * 设置 若失败则为异常信息
     *
     * @param amount 若失败则为异常信息
     */
    public void setAmount(OrderPaymentDetailAmount amount) {
        this.amount = amount;
    }
}
