/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.biz.system.service.impl;

import cn.sinozg.applet.biz.system.service.FrameworkPayService;
import cn.sinozg.applet.biz.system.service.PaymentService;
import cn.sinozg.applet.biz.system.vo.request.OrderPaymentAmount;
import cn.sinozg.applet.biz.system.vo.request.OrderPaymentCloseRequest;
import cn.sinozg.applet.biz.system.vo.request.OrderPaymentPayer;
import cn.sinozg.applet.biz.system.vo.request.OrderPaymentRequest;
import cn.sinozg.applet.biz.system.vo.request.OrderRefundAmount;
import cn.sinozg.applet.biz.system.vo.request.OrderRefundRequest;
import cn.sinozg.applet.biz.system.vo.request.WebPaymentRequest;
import cn.sinozg.applet.biz.system.vo.request.WebRefundRequest;
import cn.sinozg.applet.biz.system.vo.response.OrderPaymentResponse;
import cn.sinozg.applet.biz.system.vo.response.OrderRefundResponse;
import cn.sinozg.applet.biz.system.vo.response.PaymentCallbackDetail;
import cn.sinozg.applet.biz.system.vo.response.PaymentCallbackResponse;
import cn.sinozg.applet.biz.system.vo.response.RefundCallbackDetail;
import cn.sinozg.applet.common.core.model.LoginUserVo;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.properties.WechatValue;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.PayUtil;
import cn.sinozg.applet.common.utils.UserUtil;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentServiceImpl
implements PaymentService {
    @Resource
    private AppValue appValue;
    @Resource
    private FrameworkPayService payService;
    private final Logger log = LoggerFactory.getLogger(PaymentServiceImpl.class);

    @Override
    public String payment(WebPaymentRequest param) {
        LoginUserVo user = UserUtil.user();
        WechatValue wechat = this.appValue.getWechat();
        OrderPaymentRequest payRequest = this.generatePayRequest(param, user.getOpenId());
        OrderPaymentResponse result = PayUtil.post(wechat.getUnifiedOrderUrl(), payRequest, OrderPaymentResponse.class);
        if (result == null || StringUtils.isEmpty((CharSequence)result.getPrepayId())) {
            throw new CavException("BIZ000100007");
        }
        return result.getPrepayId();
    }

    @Override
    public boolean closeOrder(String outTradeNo) {
        WechatValue wechat = this.appValue.getWechat();
        OrderPaymentCloseRequest request = new OrderPaymentCloseRequest();
        request.setMchId(wechat.getMchId());
        String url = String.format(wechat.getCloseUrl(), outTradeNo);
        String result = PayUtil.post(url, request, String.class);
        return Strings.CS.equals("{}", result);
    }

    @Override
    public PaymentCallbackResponse paymentCallback(HttpServletRequest request) {
        this.log.info("\u652f\u4ed8\u56de\u8c03..................");
        PaymentCallbackResponse response = new PaymentCallbackResponse();
        response.setCode("FAIL");
        String body = this.body(request);
        try {
            this.log.info("\u652f\u4ed8\u56de\u8c03\u62a5\u6587\u4fe1\u606f\uff1a{}", (Object)body);
            boolean flag = PayUtil.signVerify(request, body);
            if (!flag) {
                throw new RuntimeException("\u652f\u4ed8\u6821\u9a8c\u5931\u8d25\uff01");
            }
            String json = PayUtil.decryptOrder(body);
            this.log.info("\u56de\u8c03\u540e\u7684\u89e3\u5bc6\u6d88\u606f\uff0c{}", (Object)json);
            PaymentCallbackDetail detail = (PaymentCallbackDetail)JsonUtil.toPojo((String)json, PaymentCallbackDetail.class);
            if (detail == null) {
                throw new RuntimeException("\u89e3\u6790\u652f\u4ed8\u53c2\u6570\u5931\u8d25\uff01");
            }
            this.payService.paymentCallback(detail.getOutTradeNo(), "SUCCESS".equals(detail.getTradeState()), detail);
            response.setCode("SUCCESS");
            response.setMessage("\u6210\u529f\uff01");
        }
        catch (Exception e) {
            this.log.error("\u652f\u4ed8\u56de\u8c03 \u5904\u7406\u56de\u8c03\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @Override
    public OrderRefundResponse refund(WebRefundRequest params) {
        WechatValue wechat = this.appValue.getWechat();
        OrderRefundRequest request = new OrderRefundRequest();
        request.setTransactionId(params.getTransactionId());
        request.setOutRefundNo(params.getRefundNo());
        request.setFundsAccount("AVAILABLE");
        request.setNotifyUrl(wechat.getRefundCallbackUrl());
        request.setReason(params.getRefundDesc());
        OrderRefundAmount amount = new OrderRefundAmount();
        amount.setTotal(params.getTotalFee());
        amount.setRefund(params.getRefundFee());
        request.setAmount(amount);
        OrderRefundResponse refundInfo = PayUtil.post(wechat.getRefundUrl(), request, OrderRefundResponse.class);
        if (refundInfo == null || !"SUCCESS".equals(refundInfo.getStatus())) {
            throw new CavException("BIZ000100008");
        }
        return refundInfo;
    }

    @Override
    public PaymentCallbackResponse refundCallBack(HttpServletRequest request) {
        this.log.info("\u9000\u6b3e\u56de\u8c03..................");
        PaymentCallbackResponse response = new PaymentCallbackResponse();
        response.setCode("FAIL");
        String body = this.body(request);
        try {
            this.log.info("\u9000\u6b3e\u56de\u8c03\u62a5\u6587\u4fe1\u606f\uff1a{}", (Object)body);
            boolean flag = PayUtil.signVerify(request, body);
            if (!flag) {
                throw new RuntimeException("\u9000\u6b3e\u6821\u9a8c\u5931\u8d25\uff01");
            }
            String json = PayUtil.decryptOrder(body);
            this.log.info("\u9000\u6b3e\u56de\u8c03\u540e\u7684\u89e3\u5bc6\u6d88\u606f\uff0c{}", (Object)json);
            RefundCallbackDetail detail = (RefundCallbackDetail)JsonUtil.toPojo((String)json, RefundCallbackDetail.class);
            if (detail == null) {
                throw new RuntimeException("\u89e3\u6790\u9000\u6b3e\u53c2\u6570\u5931\u8d25\uff01");
            }
            boolean b = this.payService.refundCallback(detail);
            if (!b) {
                throw new RuntimeException("\u66f4\u65b0\u4e1a\u52a1\u6570\u636e\u5931\u8d25\uff01");
            }
            response.setCode("SUCCESS");
            response.setMessage("\u6210\u529f\uff01");
        }
        catch (Exception e) {
            this.log.error("\u9000\u6b3e\u56de\u8c03 \u5904\u7406\u56de\u8c03\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    private String body(HttpServletRequest request) {
        StringBuilder body = new StringBuilder();
        try (BufferedReader br = request.getReader();){
            String temp;
            while ((temp = br.readLine()) != null) {
                body.append(temp);
            }
        }
        catch (Exception e) {
            this.log.error("\u83b7\u53d6\u8bf7\u6c42\u4f53\u5931\u8d25\uff01", (Throwable)e);
        }
        return body.toString();
    }

    private OrderPaymentRequest generatePayRequest(WebPaymentRequest params, String openId) {
        WechatValue wechat = this.appValue.getWechat();
        OrderPaymentRequest request = new OrderPaymentRequest();
        request.setAppId(wechat.getAppid());
        request.setMchId(wechat.getMchId());
        request.setNotifyUrl(wechat.getNotifyUrl());
        request.setDescription(params.getDescription());
        request.setOutTradeNo(params.getOrderId());
        OrderPaymentAmount amount = new OrderPaymentAmount();
        amount.setTotal(params.getTotalFee());
        request.setAmount(amount);
        OrderPaymentPayer payer = new OrderPaymentPayer();
        payer.setOpenId(openId);
        request.setPayer(payer);
        return request;
    }
}

