/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.system.vo.request;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;

/**
 * 前端传入的订单支付信息
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-24 下午 09:35
 **/
public class WebPaymentRequest {
    /**订单ID*/
    @NotEmpty(message = "{TIRSCI.WebPaymentRequest.orderId}")
    @Schema(description = "订单ID")
    private String orderId;
    /**商品金额*/
    @Schema(description = "商品金额")
    private int totalFee;
    @NotEmpty(message = "{TIRSCI.WebPaymentRequest.description}")
    @Schema(description = "商铺描述")
    private String description;

    /**
     * 获取 订单ID
     *
     * @return orderId 订单ID
     */
    public String getOrderId() {
        return this.orderId;
    }

    /**
     * 设置 订单ID
     *
     * @param orderId 订单ID
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * 获取 商品金额
     *
     * @return totalFee 商品金额
     */
    public int getTotalFee() {
        return this.totalFee;
    }

    /**
     * 设置 商品金额
     *
     * @param totalFee 商品金额
     */
    public void setTotalFee(int totalFee) {
        this.totalFee = totalFee;
    }

    /**
     * 获取 @NotEmpty(message = "{TIRSCI.WebPaymentRequest.description}")    @Schema(description = "商铺描述")
     *
     * @return description @NotEmpty(message = "{TIRSCI.WebPaymentRequest.description}")    @Schema(description = "商铺描述")
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * 设置 @NotEmpty(message = "{TIRSCI.WebPaymentRequest.description}")    @Schema(description = "商铺描述")
     *
     * @param description @NotEmpty(message = "{TIRSCI.WebPaymentRequest.description}")    @Schema(description = "商铺描述")
     */
    public void setDescription(String description) {
        this.description = description;
    }
}