package cn.sinozg.applet.tool.model;

import cn.sinozg.applet.common.utils.PojoUtil;
import io.swagger.v3.oas.annotations.media.Schema;

import java.util.List;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-07-08 22:56
 */
public class RepeatClassRequest {
    @Schema(description = "根目录")
    private String rootPath;
    @Schema(description = "验证文件目录")
    private String validatorFile;
    @Schema(description = "存在的包")
    private List<String> existPackage;
    @Schema(description = "默认存在的包")
    private List<String> defaultExistPackage = PojoUtil.arrayToList(".biz.", ".common.", ".vo.", ".model.", ".dto.", ".enums.");
    @Schema(description = "排除的包")
    private List<String> excludePackage;
    @Schema(description = "默认排除的包")
    private List<String> defaultExcludePackage = PojoUtil.arrayToList(".config.", ".test.", ".scheduled.", ".serializer.", ".impl.", ".tag.");

    public RepeatClassRequest(String rootPath){
        this.rootPath = rootPath;
    }

    public String getRootPath() {
        return rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getValidatorFile() {
        return validatorFile;
    }

    public void setValidatorFile(String validatorFile) {
        this.validatorFile = validatorFile;
    }

    public List<String> getExistPackage() {
        return existPackage;
    }

    public void setExistPackage(List<String> existPackage) {
        this.existPackage = existPackage;
    }

    public List<String> getDefaultExistPackage() {
        if (existPackage != null) {
            this.defaultExistPackage.addAll(existPackage);
        }
        return defaultExistPackage;
    }

    public void setDefaultExistPackage(List<String> defaultExistPackage) {
        this.defaultExistPackage = defaultExistPackage;
    }

    public List<String> getExcludePackage() {
        return excludePackage;
    }

    public void setExcludePackage(List<String> excludePackage) {
        this.excludePackage = excludePackage;
    }

    public List<String> getDefaultExcludePackage() {
        return defaultExcludePackage;
    }

    public void setDefaultExcludePackage(List<String> defaultExcludePackage) {
        if (excludePackage != null) {
            this.defaultExcludePackage.addAll(excludePackage);
        }
        this.defaultExcludePackage = defaultExcludePackage;
    }
}
