package cn.sinozg.applet.tool;

import cn.sinozg.applet.tool.model.MapperReplaceInfo;
import cn.sinozg.applet.tool.model.MapperReplaceResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * mapper xml文件替换 baseSql
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-07-08 23:27
 */
public class MapperReplace {

    // \\s\\S
    private static final Pattern PATTERN = Pattern.compile("(?<=<sql id=\"Base_Column_List\">)[^<]*(?=</sql>)");

    /**
     * xml文件替换 baseSq
     * @param sourcePath 资源文件
     * @param targetPath 要替换的文件目录
     * @return 返回信息
     */
    public static MapperReplaceResponse replace(String sourcePath, String targetPath){
        MapperReplaceResponse response = new MapperReplaceResponse();
        Map<String, MapperReplaceInfo> sourceMap = new HashMap<>(1024);
        Map<String, MapperReplaceInfo> targetMap = new HashMap<>(1024);
        File sourceFile = new File(sourcePath);
        File targetFile = new File(targetPath);
        itemMapper(sourceMap, sourceFile);
        itemMapper(targetMap, targetFile);
        int sourceSize = sourceMap.size();
        int targetSize = targetMap.size();
        response.setSourceSize(sourceMap.size());
        response.setTargetSize(targetMap.size());
        System.out.println("原始表数量" + sourceSize + ",目标表数量:" + targetSize);
        try {
            replaceSql(sourceMap, targetMap, response);
            if (targetSize != sourceSize) {
                absentTable(sourceMap, targetMap, response);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }


    private static void absentTable(Map<String, MapperReplaceInfo> sourceMap, Map<String, MapperReplaceInfo> targetMap, MapperReplaceResponse response){
        for (Map.Entry<String, MapperReplaceInfo> e : sourceMap.entrySet()) {
            if (!targetMap.containsKey(e.getKey())) {
                response.addAchieve(e.getKey());
            }
        }
    }

    private static void replaceSql(Map<String, MapperReplaceInfo> sourceMap, Map<String, MapperReplaceInfo> targetMap,  MapperReplaceResponse response) throws IOException {
        MapperReplaceInfo info;
        MapperReplaceInfo ri;
        for (Map.Entry<String, MapperReplaceInfo> e : targetMap.entrySet()) {
            info = e.getValue();
            if (StringUtils.isBlank(info.getBaseSql())) {
                response.addBaseSQL(e.getKey());
            } else {
                ri = sourceMap.get(e.getKey());
                if (ri == null || StringUtils.isBlank(ri.getBaseSql())) {
                    response.addSurplusBaseSQL(e.getKey());
                } else {
                    String text = info.getText().replace(info.getBaseSql(), ri.getBaseSql());
                    FileUtils.writeStringToFile(info.getFile(), text, Charset.defaultCharset());
                }
            }
        }
    }

    private static void itemMapper(Map<String, MapperReplaceInfo> map, File file){
        if (file.isFile()) {
            String name = file.getName();
            map.put(name, findBaseColumnList(file));
        } else {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    itemMapper(map, f);
                }
            }
        }
    }

    private static MapperReplaceInfo findBaseColumnList(File file){
        String text;
        String baseSql = null;
        try {
            text = FileUtils.readFileToString(file, Charset.defaultCharset());
            Matcher matcher = PATTERN.matcher(text);
            if (matcher.find()) {
                baseSql = matcher.group();
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new MapperReplaceInfo(baseSql, file, text);
    }

}
