package cn.sinozg.applet.tool.model;

import io.swagger.v3.oas.annotations.media.Schema;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-07-08 23:30
 */
public class MapperReplaceResponse {
    @Schema(description = "原始表数量")
    private int sourceSize;
    @Schema(description = "目标表数量")
    private int targetSize;
    @Schema(description = "未找到对应的实现")
    private List<String> nonAchieve = new ArrayList<>();
    @Schema(description = "未找到对应的 baseSQL")
    private List<String> nonBaseSQL = new ArrayList<>();
    @Schema(description = "未找到资源对应的 baseSQL")
    private List<String> surplusBaseSQL = new ArrayList<>();

    public int getSourceSize() {
        return sourceSize;
    }

    public void setSourceSize(int sourceSize) {
        this.sourceSize = sourceSize;
    }

    public int getTargetSize() {
        return targetSize;
    }

    public void setTargetSize(int targetSize) {
        this.targetSize = targetSize;
    }

    public List<String> getNonAchieve() {
        return nonAchieve;
    }

    public void setNonAchieve(List<String> nonAchieve) {
        this.nonAchieve = nonAchieve;
    }

    public List<String> getNonBaseSQL() {
        return nonBaseSQL;
    }

    public void setNonBaseSQL(List<String> nonBaseSQL) {
        this.nonBaseSQL = nonBaseSQL;
    }

    public List<String> getSurplusBaseSQL() {
        return surplusBaseSQL;
    }

    public void setSurplusBaseSQL(List<String> surplusBaseSQL) {
        this.surplusBaseSQL = surplusBaseSQL;
    }

    public void addAchieve(String input){
        this.nonAchieve.add(input);
    }
    public void addBaseSQL(String input){
        this.nonBaseSQL.add(input);
    }
    public void addSurplusBaseSQL(String input){
        this.surplusBaseSQL.add(input);
    }
}
