package cn.sinozg.applet.tool;

import cn.sinozg.applet.common.utils.SnowFlake;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RegExUtils;

/**
 * 替换 dict id
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-09-29 22:06
 */
public class DictId {

    /**
     * 生产 数据字典id
     * @param path sql 脚本
     */
    public static void generatorId(String path){
        File file = new File(path);
        try {
            List<String> list = FileUtils.readLines(file, Charset.defaultCharset());
            List<String> line = new ArrayList<>();
            for (String sql : list) {
                line.add(RegExUtils.replaceAll(sql, "$", SnowFlake.genId()));
            }
            FileUtils.writeLines(file, line);
        } catch (Exception ignored) {
        }
    }
}
