package cn.sinozg.applet.tool.model;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.PojoUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.StringUtils;

import java.net.URL;
import java.util.List;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-07-08 22:56
 */
public class RepeatClassRequest {
    @Schema(description = "根目录")
    private String rootPath;
    @Schema(description = "验证文件目录")
    private String validatorFile;
    @Schema(description = "存在的包")
    private List<String> existPackage;
    @Schema(description = "默认存在的包")
    private final List<String> defaultExistPackage = PojoUtil.arrayToList(".biz.", ".common.", ".vo.", ".model.", ".dto.", ".enums.");
    @Schema(description = "排除的包")
    private List<String> excludePackage;
    @Schema(description = "默认排除的包")
    private final List<String> defaultExcludePackage = PojoUtil.arrayToList(".config.", ".test.", ".scheduled.", ".serializer.", ".impl.", ".tag.");

    public RepeatClassRequest(String rootPath){
        this.rootPath = rootPath;
    }

    public RepeatClassRequest(Class<?> runClazz) {
        URL url = runClazz.getClassLoader().getResource(StringUtils.EMPTY);
        if (url == null) {
            throw new CavException("获取项目根路径失败！");
        }
        String path = url.getPath();
        this.rootPath = path.replace("/target/classes/", "/src/");
    }

    public String getRootPath() {
        return rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getValidatorFile() {
        return validatorFile;
    }

    public void setValidatorFile(String validatorFile) {
        this.validatorFile = validatorFile;
    }

    public void setExistPackage(List<String> existPackage) {
        this.existPackage = existPackage;
    }

    public List<String> getDefaultExistPackage() {
        if (existPackage != null) {
            this.defaultExistPackage.addAll(existPackage);
        }
        return defaultExistPackage;
    }

    public void setExcludePackage(List<String> excludePackage) {
        this.excludePackage = excludePackage;
    }

    public List<String> getDefaultExcludePackage() {
        if (excludePackage != null) {
            this.defaultExcludePackage.addAll(excludePackage);
        }
        return this.defaultExcludePackage;
    }
}
