/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.tool;

import cn.sinozg.applet.tool.model.MapperReplaceInfo;
import cn.sinozg.applet.tool.model.MapperReplaceResponse;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class MapperReplace {
    private static final Pattern PATTERN = Pattern.compile("(?<=<sql id=\"Base_Column_List\">)[^<]*(?=</sql>)");

    public static MapperReplaceResponse replace(String sourcePath, String targetPath) {
        MapperReplaceResponse response = new MapperReplaceResponse();
        HashMap<String, MapperReplaceInfo> sourceMap = new HashMap<String, MapperReplaceInfo>(1024);
        HashMap<String, MapperReplaceInfo> targetMap = new HashMap<String, MapperReplaceInfo>(1024);
        File sourceFile = new File(sourcePath);
        File targetFile = new File(targetPath);
        MapperReplace.itemMapper(sourceMap, sourceFile);
        MapperReplace.itemMapper(targetMap, targetFile);
        int sourceSize = sourceMap.size();
        int targetSize = targetMap.size();
        response.setSourceSize(sourceMap.size());
        response.setTargetSize(targetMap.size());
        System.out.println("\u539f\u59cb\u8868\u6570\u91cf" + sourceSize + ",\u76ee\u6807\u8868\u6570\u91cf:" + targetSize);
        try {
            MapperReplace.replaceSql(sourceMap, targetMap, response);
            if (targetSize != sourceSize) {
                MapperReplace.absentTable(sourceMap, targetMap, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    private static void absentTable(Map<String, MapperReplaceInfo> sourceMap, Map<String, MapperReplaceInfo> targetMap, MapperReplaceResponse response) {
        for (Map.Entry<String, MapperReplaceInfo> e : sourceMap.entrySet()) {
            if (targetMap.containsKey(e.getKey())) continue;
            response.addAchieve(e.getKey());
        }
    }

    private static void replaceSql(Map<String, MapperReplaceInfo> sourceMap, Map<String, MapperReplaceInfo> targetMap, MapperReplaceResponse response) throws IOException {
        for (Map.Entry<String, MapperReplaceInfo> e : targetMap.entrySet()) {
            MapperReplaceInfo info = e.getValue();
            if (StringUtils.isBlank((CharSequence)info.getBaseSql())) {
                response.addBaseSQL(e.getKey());
                continue;
            }
            MapperReplaceInfo ri = sourceMap.get(e.getKey());
            if (ri == null || StringUtils.isBlank((CharSequence)ri.getBaseSql())) {
                response.addSurplusBaseSQL(e.getKey());
                continue;
            }
            String text = info.getText().replace(info.getBaseSql(), ri.getBaseSql());
            FileUtils.writeStringToFile((File)info.getFile(), (String)text, (Charset)Charset.defaultCharset());
        }
    }

    private static void itemMapper(Map<String, MapperReplaceInfo> map, File file) {
        if (file.isFile()) {
            String name = file.getName();
            map.put(name, MapperReplace.findBaseColumnList(file));
        } else {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    MapperReplace.itemMapper(map, f);
                }
            }
        }
    }

    private static MapperReplaceInfo findBaseColumnList(File file) {
        String text;
        String baseSql = null;
        try {
            text = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
            Matcher matcher = PATTERN.matcher(text);
            if (matcher.find()) {
                baseSql = matcher.group();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new MapperReplaceInfo(baseSql, file, text);
    }
}

