/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.tool.model;

import cn.sinozg.applet.common.core.model.I18nName;

import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-03-12 13:55
 */
public class I18nSetGet {
    private Function<I18nInfo, String> funInfo;
    private BiConsumer<I18nInfo, String> consInfo;
    private BiConsumer<I18nName, String> consName;

    public I18nSetGet(Function<I18nInfo, String> funInfo, BiConsumer<I18nInfo, String> consInfo, BiConsumer<I18nName, String> consName){
        this.funInfo = funInfo;
        this.consInfo = consInfo;
        this.consName = consName;
    }

    public Function<I18nInfo, String> getFunInfo() {
        return funInfo;
    }

    public void setFunInfo(Function<I18nInfo, String> funInfo) {
        this.funInfo = funInfo;
    }

    public BiConsumer<I18nInfo, String> getConsInfo() {
        return consInfo;
    }

    public void setConsInfo(BiConsumer<I18nInfo, String> consInfo) {
        this.consInfo = consInfo;
    }

    public BiConsumer<I18nName, String> getConsName() {
        return consName;
    }

    public void setConsName(BiConsumer<I18nName, String> consName) {
        this.consName = consName;
    }
}
