/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.tool.model;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.PojoUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.StringUtils;

import java.net.URL;
import java.util.List;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-07-08 22:56
 */
public class RepeatClassRequest {
    @Schema(description = "根目录")
    private String rootPath;
    @Schema(description = "验证文件目录")
    private String validatorFile;
    @Schema(description = "存在的包")
    private List<String> existPackage;
    @Schema(description = "默认存在的包")
    private final List<String> defaultExistPackage = PojoUtil.arrayToList(".biz.", ".common.", ".vo.", ".model.", ".dto.", ".enums.");
    @Schema(description = "排除的包")
    private List<String> excludePackage;
    @Schema(description = "默认排除的包")
    private final List<String> defaultExcludePackage = PojoUtil.arrayToList(".config.", ".test.", ".scheduled.", ".serializer.", ".impl.", ".tag.");

    public RepeatClassRequest(String rootPath){
        this.rootPath = rootPath;
    }

    public RepeatClassRequest(Class<?> runClazz) {
        URL url = runClazz.getClassLoader().getResource(StringUtils.EMPTY);
        if (url == null) {
            throw new CavException("获取项目根路径失败！");
        }
        String path = url.getPath();
        this.rootPath = path.replace("/target/classes/", "/src/");
    }

    public String getRootPath() {
        return rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getValidatorFile() {
        return validatorFile;
    }

    public void setValidatorFile(String validatorFile) {
        this.validatorFile = validatorFile;
    }

    public void setExistPackage(List<String> existPackage) {
        this.existPackage = existPackage;
    }

    public List<String> getDefaultExistPackage() {
        if (existPackage != null) {
            this.defaultExistPackage.addAll(existPackage);
        }
        return defaultExistPackage;
    }

    public void setExcludePackage(List<String> excludePackage) {
        this.excludePackage = excludePackage;
    }

    public List<String> getDefaultExcludePackage() {
        if (excludePackage != null) {
            this.defaultExcludePackage.addAll(excludePackage);
        }
        return this.defaultExcludePackage;
    }
}
