/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.tool.model;

import io.swagger.v3.oas.annotations.media.Schema;

/**
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-07 23:12
 */
public class I18nInfo {
    /** key值 */
    @Schema(description = "key值")
    private String key;
    /** 中文 */
    @Schema(description = "中文")
    private String cn;

    /** 英文 */
    @Schema(description = "英文")
    private String en;
    /** 西班牙语 */
    @Schema(description = "西班牙语")
    private String es;
    /** 法语 */
    @Schema(description = "法语")
    private String fr;
    /** 日语 */
    @Schema(description = "日语")
    private String ja;

    /**
     * 获取 key值
     *
     * @return key key值
     */
    public String getKey() {
        return this.key;
    }

    /**
     * 设置 key值
     *
     * @param key key值
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * 获取 中文
     *
     * @return cn 中文
     */
    public String getCn() {
        return this.cn;
    }

    /**
     * 设置 中文
     *
     * @param cn 中文
     */
    public void setCn(String cn) {
        this.cn = cn;
    }

    /**
     * 获取 英文
     *
     * @return en 英文
     */
    public String getEn() {
        return this.en;
    }

    /**
     * 设置 英文
     *
     * @param en 英文
     */
    public void setEn(String en) {
        this.en = en;
    }

    /**
     * 获取 西班牙语
     *
     * @return es 西班牙语
     */
    public String getEs() {
        return this.es;
    }

    /**
     * 设置 西班牙语
     *
     * @param es 西班牙语
     */
    public void setEs(String es) {
        this.es = es;
    }

    /**
     * 获取 法语
     *
     * @return ja 法语
     */
    public String getFr() {
        return this.fr;
    }

    /**
     * 设置 法语
     *
     * @param fr 法语
     */
    public void setFr(String fr) {
        this.fr = fr;
    }
    /**
     * 获取 日语
     *
     * @return ja 日语
     */
    public String getJa() {
        return this.ja;
    }

    /**
     * 设置 日语
     *
     * @param ja 日语
     */
    public void setJa(String ja) {
        this.ja = ja;
    }
}
