/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.tool.model;

import io.swagger.v3.oas.annotations.media.Schema;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-07-08 23:06
 */
public class RepeatClassResponse {
    @Schema(description = "没有被引用")
    private List<String> nonQuote = new ArrayList<>();
    @Schema(description = "java文件总数")
    private int totalFileSize;
    @Schema(description = "java文件总数")
    private int javaFileSize;
    @Schema(description = "处理java文件总数")
    private int handleFileSize;
    @Schema(description = "schema不同")
    private List<String> differentSchema = new ArrayList<>();
    @Schema(description = "schema错误")
    private List<String> errorSchema = new ArrayList<>();
    @Schema(description = "多余的验证信息")
    private List<String> surplusValidatorCode = new ArrayList<>();
    public List<String> getNonQuote() {
        return nonQuote;
    }

    public void setNonQuote(List<String> nonQuote) {
        this.nonQuote = nonQuote;
    }

    public int getTotalFileSize() {
        return totalFileSize;
    }

    public void setTotalFileSize(int totalFileSize) {
        this.totalFileSize = totalFileSize;
    }

    public int getJavaFileSize() {
        return javaFileSize;
    }

    public void setJavaFileSize(int javaFileSize) {
        this.javaFileSize = javaFileSize;
    }

    public int getHandleFileSize() {
        return handleFileSize;
    }

    public void setHandleFileSize(int handleFileSize) {
        this.handleFileSize = handleFileSize;
    }

    public List<String> getDifferentSchema() {
        return differentSchema;
    }

    public void setDifferentSchema(List<String> differentSchema) {
        this.differentSchema = differentSchema;
    }

    public List<String> getErrorSchema() {
        return errorSchema;
    }

    public void setErrorSchema(List<String> errorSchema) {
        this.errorSchema = errorSchema;
    }

    public List<String> getSurplusValidatorCode() {
        return surplusValidatorCode;
    }

    public void setSurplusValidatorCode(List<String> surplusValidatorCode) {
        this.surplusValidatorCode = surplusValidatorCode;
    }

    public void addNonQuote (String input){
        nonQuote.add(input);
    }
    public void addDifferentSchema (String input){
        differentSchema.add(input);
    }
    public void addErrorSchema (String input){
        errorSchema.add(input);
    }
    public void addSurplusValidatorCode (String input){
        surplusValidatorCode.add(input);
    }

}
