/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.tool.model;

import io.swagger.v3.oas.annotations.media.Schema;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-07-08 23:30
 */
public class MapperReplaceResponse {
    @Schema(description = "原始表数量")
    private int sourceSize;
    @Schema(description = "目标表数量")
    private int targetSize;
    @Schema(description = "未找到对应的实现")
    private List<String> nonAchieve = new ArrayList<>();
    @Schema(description = "未找到对应的 baseSQL")
    private List<String> nonBaseSql = new ArrayList<>();
    @Schema(description = "未找到资源对应的 baseSQL")
    private List<String> surplusBaseSql = new ArrayList<>();

    public int getSourceSize() {
        return sourceSize;
    }

    public void setSourceSize(int sourceSize) {
        this.sourceSize = sourceSize;
    }

    public int getTargetSize() {
        return targetSize;
    }

    public void setTargetSize(int targetSize) {
        this.targetSize = targetSize;
    }

    public List<String> getNonAchieve() {
        return nonAchieve;
    }

    public void setNonAchieve(List<String> nonAchieve) {
        this.nonAchieve = nonAchieve;
    }

    public List<String> getNonBaseSql() {
        return nonBaseSql;
    }

    public void setNonBaseSql(List<String> nonBaseSql) {
        this.nonBaseSql = nonBaseSql;
    }

    public List<String> getSurplusBaseSql() {
        return surplusBaseSql;
    }

    public void setSurplusBaseSql(List<String> surplusBaseSql) {
        this.surplusBaseSql = surplusBaseSql;
    }

    public void addAchieve(String input){
        this.nonAchieve.add(input);
    }
    public void addBaseSql(String input){
        this.nonBaseSql.add(input);
    }
    public void addSurplusBaseSql(String input){
        this.surplusBaseSql.add(input);
    }
}
