/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.tool.enums;

/**
 * @Description
 * @Copyright Copyright (c) 2025
 * @author xyb
 * @since 2025-03-17 21:43:41
*/
public enum SheetEnum {
    MASSAGES(0, "massages"),
    VALIDATOR(1, "validator"),
    TITLE(2, "title"),
    VUE(3, "vue"),
    DICT(4, "dict"),
    APP(5, "app"),
            ;
    private final int sheetNo;
    private final String type;

    SheetEnum(int sheetNo, String type) {
        this.sheetNo = sheetNo;
        this.type = type;
    }

    public static SheetEnum ofCode(int sheetNo) {
        for (SheetEnum sheetEnum : SheetEnum.values()) {
            if (sheetEnum.getSheetNo() == sheetNo) {
                return sheetEnum;
            }
        }
        return MASSAGES;
    }

    public int getSheetNo() {
        return sheetNo;
    }
    public String getType() {
        return type;
    }
}

