/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.tool.model;

import java.util.List;
import java.util.function.Supplier;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-03-12 15:54
 */
public class ReadConfigParams<T> {

    private String vuePath;
    private String appPath;

    private Supplier<List<DictI18n>> dict;

    private Class<T> out;

    public ReadConfigParams(String vuePath, String appPath, Class<T> out){
        this.vuePath = vuePath;
        this.appPath = appPath;
        this.out = out;
    }

    public String getVuePath() {
        return vuePath;
    }

    public void setVuePath(String vuePath) {
        this.vuePath = vuePath;
    }

    public String getAppPath() {
        return appPath;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    public Supplier<List<DictI18n>> getDict() {
        return dict;
    }

    public void setDict(Supplier<List<DictI18n>> dict) {
        this.dict = dict;
    }

    public Class<T> getOut() {
        return out;
    }

    public void setOut(Class<T> out) {
        this.out = out;
    }
}
