/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.tool.model;

import cn.sinozg.applet.common.core.model.I18nName;
import cn.sinozg.applet.tool.enums.I18nTp;
import cn.sinozg.applet.tool.enums.SheetEnum;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-03-07 22:20
 */
public class WriteConfigParams {
    /** 导入的数据 */
    private List<I18nInfo> data;
    /** vue 配置路径 */
    private String vuePath;
    /** 更新 标准数据 */
    private Consumer<DictI18n> dictUpdate;
    /** 更新 标准数据 root */
    private Supplier<Boolean> dictRoot;
    /** sheet 页相关 */
    private SheetEnum sheet;
    /** 语言 */
    private I18nTp i18nTp;
    /** 处理路由 */
    private BiConsumer<Map<String, String>, BiConsumer<I18nName, String>> route;

    public WriteConfigParams(String i18nTp, int sheetNo, String path) {
        this.vuePath = path;
        this.sheet = SheetEnum.ofCode(sheetNo);
        this.i18nTp = I18nTp.ofCode(i18nTp);
    }

    public List<I18nInfo> getData() {
        return data;
    }

    public void setData(List<I18nInfo> data) {
        this.data = data;
    }

    public String getVuePath() {
        return vuePath;
    }

    public void setVuePath(String vuePath) {
        this.vuePath = vuePath;
    }

    public Consumer<DictI18n> getDictUpdate() {
        return dictUpdate;
    }

    public void setDictUpdate(Consumer<DictI18n> dictUpdate) {
        this.dictUpdate = dictUpdate;
    }

    public Supplier<Boolean> getDictRoot() {
        return dictRoot;
    }

    public void setDictRoot(Supplier<Boolean> dictRoot) {
        this.dictRoot = dictRoot;
    }

    public SheetEnum getSheet() {
        return sheet;
    }

    public void setSheet(SheetEnum sheet) {
        this.sheet = sheet;
    }

    public I18nTp getI18nTp() {
        return i18nTp;
    }

    public void setI18nTp(I18nTp i18nTp) {
        this.i18nTp = i18nTp;
    }

    public BiConsumer<Map<String, String>, BiConsumer<I18nName, String>> getRoute() {
        return route;
    }

    public void setRoute(BiConsumer<Map<String, String>, BiConsumer<I18nName, String>> route) {
        this.route = route;
    }
}
