/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.tool.enums;

import org.apache.commons.lang3.Strings;

/**
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-07 23:15
 */
public enum I18nTp {

    /** 中国 */
    CN("zh"),
    /** 英文 */
    EN("en"),
    /** 西班牙 */
    ES("es"),
    /** 日语 */
    JA("ja"),
    /** 法语 */
    FR("fr"),
    ;

    private final String code;

    I18nTp(String code) {
        this.code = code;
    }
    public String getCode() {
        return this.code;
    }
    public static I18nTp ofCode (String code){
        for (I18nTp v : values()) {
            if (code.equals(v.getCode())) {
                return v;
            }
        }
        return CN;
    }
    public static I18nTp contains (String code){
        for (I18nTp v : values()) {
            if (Strings.CS.contains(code, v.getCode())) {
                return v;
            }
        }
        return CN;
    }
}
