/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.tool.model;

import cn.sinozg.applet.common.core.model.I18nName;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-08 16:18
 */
public class DictI18n {

    /** 类型 */
    @Schema(description = "类型")
    private String type;

    /** 值 */
    @Schema(description = "值")
    private String value;

    /** 国际化值 */
    @Schema(description = "国际化值")
    private I18nName name;

    /**
     * 获取 类型
     *
     * @return type 类型
     */
    public String getType() {
        return this.type;
    }

    /**
     * 设置 类型
     *
     * @param type 类型
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * 获取 值
     *
     * @return value 值
     */
    public String getValue() {
        return this.value;
    }

    /**
     * 设置 值
     *
     * @param value 值
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * 获取 国际化值
     *
     * @return name 国际化值
     */
    public I18nName getName() {
        return this.name;
    }

    /**
     * 设置 国际化值
     *
     * @param name 国际化值
     */
    public void setName(I18nName name) {
        this.name = name;
    }
}
