package cn.sinozg.applet.tool.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-06-30 17:44
 */
public class NotBlankChecker {

    /** 最大向下几行查找字段声明 */
    private static final int MAX_LOOKAHEAD = 6;

    public static void checkProject(String path) {
        Path root = Paths.get(path);
        try (Stream<Path> stream = Files.walk(root)){
            stream.filter(p -> p.toString().endsWith(".java"))
                    .forEach(NotBlankChecker::checkFile);
        } catch (Exception e) {
            System.err.println("❌ checkProject 读取失败：" + e.getMessage());
        }
    }

    private static void checkFile(Path filePath) {
        try {
            List<String> lines = Files.readAllLines(filePath);
            for (int i = 0; i < lines.size(); i++) {
                String line = lines.get(i).trim();
                // 找到 @NotBlank 注解
                if (line.startsWith("@NotBlank")) {
                    // 向下扫描字段定义
                    for (int j = 1; j <= MAX_LOOKAHEAD && i + j < lines.size(); j++) {
                        String nextLine = lines.get(i + j).trim();

                        // 跳过空行或其他注解
                        if (nextLine.isEmpty() || nextLine.startsWith("@")) {
                            continue;
                        }

                        // 尝试识别字段定义
                        // 找到非注解非字段定义，提前退出
                        if (nextLine.matches("(private|protected|public)?\\s+[\\w<>\\[\\]]+\\s+\\w+\\s*;")) {
                            String[] tokens = nextLine.split("\\s+");
                            if (tokens.length >= 3) {
                                String type = tokens[1];
                                String name = tokens[2].replace(";", "");
                                if (!"String".equals(type)) {
                                    System.out.printf("⚠️  %s:%d - @NotBlank used on non-String field '%s' (type: %s)%n", filePath, i + j + 1, name, type);
                                }
                            }
                        }
                        break;
                    }
                }
            }
        } catch (IOException e) {
            System.err.println("❌ 读取失败：" + filePath);
        }
    }
}
