/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.tool.i18n;

import cn.sinozg.applet.common.core.model.I18nName;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.tool.enums.I18nTp;
import cn.sinozg.applet.tool.enums.SheetEnum;
import cn.sinozg.applet.tool.model.DictI18n;
import cn.sinozg.applet.tool.model.I18nInfo;
import cn.sinozg.applet.tool.model.I18nSetGet;
import cn.sinozg.applet.tool.model.ReadConfigParams;
import cn.sinozg.applet.tool.model.WriteConfigParams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class I18nReadWrite {
    private static final String EQ = "=";
    private static final String MSG = "messages";
    private static final String VALIDATOR = "validator";
    private static final String TITLE = "title";
    private static final Map<String, String> MAP = new TreeMap<String, String>();
    private static final Pattern PATTERN = Pattern.compile("\"[A-Za-z0-9]+\" :");
    private static final Logger log = LoggerFactory.getLogger(I18nReadWrite.class);
    public static final Map<I18nTp, I18nSetGet> MAPPER = new LinkedHashMap<I18nTp, I18nSetGet>();

    public static <T> List<List<T>> readConfig(ReadConfigParams<T> params) {
        ArrayList<List<T>> data = new ArrayList<List<T>>();
        Class<T> clazz = params.getOut();
        Map<String, List<String>> config = I18nReadWrite.readJavaI18n();
        Map<String, List<I18nInfo>> map = I18nReadWrite.readJavaI18n(config, true);
        for (Map.Entry<String, List<I18nInfo>> e : map.entrySet()) {
            data.add(PojoUtil.copyList(e.getValue(), clazz));
        }
        if (StringUtils.isNotBlank((CharSequence)params.getVuePath())) {
            List<I18nInfo> vue = I18nReadWrite.readVue(params.getVuePath());
            data.add(PojoUtil.copyList(vue, clazz));
        }
        if (params.getDict() != null) {
            List<DictI18n> dictList = params.getDict().get();
            List<I18nInfo> dict = I18nReadWrite.readDict(dictList);
            data.add(PojoUtil.copyList(dict, clazz));
        }
        if (StringUtils.isNotBlank((CharSequence)params.getAppPath())) {
            map = I18nReadWrite.readApp(params.getAppPath());
            for (Map.Entry<String, List<I18nInfo>> e : map.entrySet()) {
                data.add(PojoUtil.copyList(e.getValue(), clazz));
            }
        }
        return data;
    }

    public static void importExcel(WriteConfigParams params) {
        SheetEnum sheet = params.getSheet();
        List<I18nInfo> list = params.getData();
        if (sheet == SheetEnum.DICT) {
            I18nReadWrite.updateDict(params);
        } else if (sheet == SheetEnum.VUE) {
            Map<String, String> map = I18nReadWrite.writeToVue(params.getData(), params.getI18nTp(), params.getVuePath());
            map.forEach((k, v) -> {
                System.out.println((String)k);
                System.out.println("-----------------------------------");
                System.out.println((String)v);
                System.out.println();
                System.out.println();
                System.out.println();
                System.out.println();
            });
            I18nReadWrite.printRoute(params);
        } else if (sheet == SheetEnum.APP) {
            HashMap<String, String> map = new HashMap<String, String>();
            Function<I18nInfo, String> function = I18nReadWrite.getFun(params.getI18nTp());
            for (I18nInfo i : list) {
                map.put(i.getKey(), function.apply(i));
            }
            System.out.println(JsonUtil.toJson(map));
        } else {
            List<String> lines = I18nReadWrite.writeJavaWithCn(list, sheet.getType(), params.getI18nTp());
            String text = String.join((CharSequence)"\n", lines);
            System.out.println(text);
        }
    }

    private static List<I18nInfo> readDict(List<DictI18n> list) {
        ArrayList<I18nInfo> infos = new ArrayList<I18nInfo>();
        for (DictI18n dict : list) {
            String key = dict.getType() + ":" + dict.getValue();
            I18nInfo info = new I18nInfo();
            info.setKey(key);
            I18nName name = dict.getName();
            info.setCn(name.getName());
            info.setEn(name.getEnName());
            info.setJa(name.getJaName());
            info.setEs(name.getEsName());
            infos.add(info);
        }
        return infos;
    }

    private static void updateDict(WriteConfigParams params) {
        Consumer<DictI18n> consumer = params.getDictUpdate();
        for (I18nInfo info : params.getData()) {
            DictI18n d = new DictI18n();
            I18nName name = new I18nName();
            name.setName(info.getCn());
            name.setEnName(info.getEn());
            name.setEsName(info.getEs());
            name.setJaName(info.getJa());
            d.setName(name);
            String[] ks = StringUtils.split((String)info.getKey(), (String)":");
            d.setType(ks[0]);
            d.setValue(ks[1]);
            if (consumer == null) continue;
            consumer.accept(d);
        }
        Supplier<Boolean> supplier = params.getDictRoot();
        if (supplier != null) {
            supplier.get();
        }
    }

    private static List<String> writeJavaWithCn(List<I18nInfo> list, String type, I18nTp tp) {
        Map<String, List<String>> config = I18nReadWrite.readJavaI18n();
        HashMap values = new HashMap();
        Function<I18nInfo, String> fun = I18nReadWrite.getFun(tp);
        list.forEach(i -> values.put(i.getKey(), (String)fun.apply((I18nInfo)i)));
        List<String> configs = config.get(type + "_zh");
        ArrayList<String> result = new ArrayList<String>();
        for (String line : configs) {
            String[] vs;
            Object nl = line;
            if (Strings.CS.contains((CharSequence)line, (CharSequence)EQ) && (vs = StringUtils.split((String)line, (String)EQ)) != null && vs.length == 2) {
                String key = vs[0];
                nl = key + EQ + (String)values.get(key);
            }
            result.add((String)nl);
        }
        return result;
    }

    private static Map<String, String> writeToVue(List<I18nInfo> list, I18nTp tp, String path) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> jsJson = new HashMap<String, String>();
        Function<I18nInfo, String> fun = I18nReadWrite.getFun(tp);
        for (I18nInfo ii : list) {
            I18nReadWrite.setMap(ii, fun, map);
        }
        Map<String, Object> oldMap = I18nReadWrite.i18nValueMap(path).get((Object)I18nTp.CN);
        I18nReadWrite.recursionSet(oldMap, map);
        Iterator<Map.Entry<String, Object>> it = oldMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            Object v = e.getValue();
            if (!I18nReadWrite.firstValueIsMap(v)) continue;
            jsJson.put(e.getKey(), I18nReadWrite.toJsJson(v));
            it.remove();
        }
        jsJson.put("app", I18nReadWrite.toJsJson(oldMap));
        return jsJson;
    }

    private static List<I18nInfo> readVue(String path) {
        Map<I18nTp, Map<String, Object>> valueMap = I18nReadWrite.i18nValueMap(path);
        TreeMap<String, I18nInfo> valuesMap = new TreeMap<String, I18nInfo>();
        for (Map.Entry<I18nTp, Map<String, Object>> e : valueMap.entrySet()) {
            I18nReadWrite.toMap(e.getValue(), "", I18nReadWrite.setFun(e.getKey()), valuesMap);
        }
        ArrayList<I18nInfo> list = new ArrayList<I18nInfo>();
        valuesMap.forEach((k, v) -> list.add((I18nInfo)v));
        return list;
    }

    private static Map<String, List<I18nInfo>> readApp(String path) {
        File file = new File(path);
        File[] fs = file.listFiles();
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>();
        try {
            if (fs != null) {
                for (File f : fs) {
                    String fm = f.getName();
                    if (!Strings.CI.equals(fm, ".json")) continue;
                    I18nTp tp = I18nTp.contains(fm);
                    String json = FileUtils.readFileToString((File)f, (Charset)Charset.defaultCharset());
                    Map map = JsonUtil.toMap((String)json);
                    ArrayList<CallSite> value = new ArrayList<CallSite>();
                    for (Map.Entry e : map.entrySet()) {
                        value.add((CallSite)((Object)((String)e.getKey() + EQ + String.valueOf(e.getValue()))));
                    }
                    result.put("app_" + tp.getCode(), value);
                }
            }
        }
        catch (Exception e) {
            throw new CavException(e);
        }
        return I18nReadWrite.readJavaI18n(result, false);
    }

    private static void printRoute(WriteConfigParams params) {
        Function<I18nInfo, String> get = I18nReadWrite.getFun(params.getI18nTp());
        String prefix = "route.";
        HashMap mapper = new HashMap();
        params.getData().forEach(i -> {
            if (Strings.CS.startsWith((CharSequence)i.getKey(), (CharSequence)prefix)) {
                mapper.put(Strings.CS.replace(i.getKey(), prefix, ""), (String)get.apply((I18nInfo)i));
            }
        });
        BiConsumer<Map<String, String>, BiConsumer<I18nName, String>> route = params.getRoute();
        if (route != null) {
            route.accept(mapper, I18nReadWrite.i18nPair(params.getI18nTp()).getConsName());
        }
    }

    private static Map<I18nTp, Map<String, Object>> i18nValueMap(String path) {
        File file = new File(path);
        I18nReadWrite.isVue(file, path);
        HashMap<I18nTp, StringBuilder> outMap = new HashMap<I18nTp, StringBuilder>();
        for (Map.Entry<String, String> entry : MAP.entrySet()) {
            String tp = StringUtils.substringBetween((String)entry.getKey(), (String)"_", (String)".");
            I18nTp itp = I18nTp.ofCode(tp);
            StringBuilder sb = (StringBuilder)outMap.get((Object)itp);
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(entry.getValue()).append(",\n");
            outMap.put(itp, sb);
        }
        HashMap<I18nTp, Map<String, Object>> valuesMap = new HashMap<I18nTp, Map<String, Object>>();
        for (Map.Entry e : outMap.entrySet()) {
            valuesMap.put((I18nTp)((Object)e.getKey()), I18nReadWrite.appendColon((StringBuilder)e.getValue()));
        }
        return valuesMap;
    }

    private static String toJsJson(Object obj) {
        String json = JsonUtil.printerJson((Object)obj);
        StringBuilder result = new StringBuilder();
        Matcher matcher = PATTERN.matcher(json);
        while (matcher.find()) {
            String group = matcher.group();
            group = group.replaceAll("\"", "");
            matcher.appendReplacement(result, group);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static boolean firstValueIsMap(Object v) {
        Map map = (Map)PojoUtil.cast((Object)v);
        Object firstValue = map.values().stream().findFirst().orElse(null);
        return !(firstValue instanceof String);
    }

    private static void setMap(I18nInfo ii, Function<I18nInfo, String> value, Map<String, Object> map) {
        String key = ii.getKey();
        String[] ks = StringUtils.split((String)key, (String)".");
        int len = ks.length;
        Map<String, Object> pmp = map;
        HashMap<String, Object> tmp = null;
        int j = len - 1;
        for (int i = 0; i < j; ++i) {
            tmp = (HashMap<String, Object>)PojoUtil.cast((Object)pmp.get(ks[i]));
            if (tmp == null) {
                tmp = new HashMap<String, Object>();
            }
            pmp.put(ks[i], tmp);
            pmp = tmp;
        }
        if (tmp != null) {
            tmp.put(ks[len - 1], value.apply(ii));
        }
    }

    private static void isVue(File file, String rootPath) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            assert (files != null);
            for (File f : files) {
                I18nReadWrite.isVue(f, rootPath);
            }
        } else {
            String fm = file.getName();
            if (fm.length() == 5) {
                I18nReadWrite.vueJson(file, rootPath, fm);
            }
        }
    }

    private static void toMap(Map<String, Object> map, String key, BiConsumer<I18nInfo, String> bc, Map<String, I18nInfo> result) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object v = entry.getValue();
            Object k = key;
            if (StringUtils.isNotBlank((CharSequence)key)) {
                k = (String)k + ".";
            }
            k = (String)k + entry.getKey();
            if (v instanceof String) {
                String s = (String)v;
                I18nInfo name = result.get(k);
                if (name == null) {
                    name = new I18nInfo();
                    name.setKey((String)k);
                }
                bc.accept(name, s);
                result.put((String)k, name);
                continue;
            }
            if (!(v instanceof Map)) continue;
            Map m = (Map)v;
            I18nReadWrite.toMap((Map)PojoUtil.cast((Object)m), (String)k, bc, result);
        }
    }

    private static Map<String, List<I18nInfo>> readJavaI18n(Map<String, List<String>> map, boolean sort) {
        HashMap config = new HashMap();
        for (Map.Entry<String, List<String>> e : map.entrySet()) {
            String[] ns = StringUtils.split((String)e.getKey(), (String)"_");
            I18nTp tp = I18nTp.ofCode(ns[1]);
            BiConsumer<I18nInfo, String> bc = I18nReadWrite.setFun(tp);
            HashMap<String, I18nInfo> temp = (HashMap<String, I18nInfo>)config.get(ns[0]);
            if (temp == null) {
                temp = new HashMap<String, I18nInfo>();
            }
            for (String v2 : e.getValue()) {
                String cv;
                if (!StringUtils.isNotBlank((CharSequence)v2) || !Strings.CS.contains((CharSequence)v2, (CharSequence)EQ)) continue;
                String[] vs = StringUtils.split((String)v2, (String)EQ);
                String key = vs[0].trim();
                I18nInfo info = (I18nInfo)temp.get(key);
                if (info == null) {
                    info = new I18nInfo();
                    info.setKey(key);
                }
                if (StringUtils.isNotBlank((CharSequence)(cv = vs[1])) && (tp == I18nTp.CN || tp == I18nTp.ES)) {
                    cv = StringUtils.trim((String)cv);
                    cv = StringEscapeUtils.unescapeJava((String)cv);
                }
                bc.accept(info, cv);
                temp.put(key, info);
            }
            config.put(ns[0], temp);
        }
        HashMap<String, List<I18nInfo>> m = new HashMap<String, List<I18nInfo>>();
        for (Map.Entry e : config.entrySet()) {
            ArrayList<I18nInfo> list = new ArrayList<I18nInfo>();
            ((Map)e.getValue()).forEach((k, v) -> list.add((I18nInfo)v));
            if (sort) {
                list.sort(Comparator.comparing(I18nInfo::getKey));
            }
            m.put((String)e.getKey(), list);
        }
        return m;
    }

    private static Map<String, List<String>> readJavaI18n() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources("classpath*:i18n/**/*.*")) {
                String path = resource.getFilename();
                List list = IOUtils.readLines((InputStream)resource.getInputStream(), (Charset)Charset.defaultCharset());
                String key = I18nReadWrite.key(path);
                ArrayList temp = (ArrayList)map.get(key);
                if (temp == null) {
                    temp = new ArrayList();
                }
                temp.addAll(list);
                map.put(key, temp);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    private static String key(String name) {
        String[] ns = StringUtils.split((String)name, (String)"_");
        int last = ns.length - 2;
        String p = MSG;
        if (Strings.CS.equals(ns[last - 1], VALIDATOR)) {
            p = VALIDATOR;
        } else if (Strings.CS.equals(ns[last - 1], TITLE)) {
            p = TITLE;
        }
        return p + "_" + ns[last];
    }

    private static Map<String, Object> appendColon(StringBuilder sb) {
        String input = "{\n" + String.valueOf(sb) + "\n}";
        String[] lines = input.split("\n");
        ArrayList<Object> list = new ArrayList<Object>();
        for (String line : lines) {
            if (Strings.CS.contains((CharSequence)line, (CharSequence)":")) {
                String[] arays = StringUtils.split((String)line, (String)":");
                try {
                    list.add("\"" + arays[0].trim() + "\":" + arays[1]);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                continue;
            }
            list.add(line);
        }
        String json = String.join((CharSequence)"\n", list);
        json = json.replaceAll("\r", "").replaceAll("\n", "");
        StringBuilder result = new StringBuilder();
        Pattern pattern = Pattern.compile(",\\s+}");
        Matcher matcher = pattern.matcher(json);
        while (matcher.find()) {
            String group = matcher.group();
            group = group.replaceAll("\\s+", "");
            matcher.appendReplacement(result, group);
        }
        matcher.appendTail(result);
        String newJson = result.toString();
        newJson = newJson.replaceAll(",}", "}");
        try {
            return JsonUtil.toMap((String)newJson);
        }
        catch (Exception e) {
            log.error("\u9519\u8bef\u7684json\uff1a{}", (Object)newJson);
            throw e;
        }
    }

    private static void vueJson(File file, String rootPath, String fm) {
        String path = file.getParent().replace(rootPath, "");
        String name = "@";
        Object text = null;
        try {
            text = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
            if (StringUtils.isNotBlank((CharSequence)path)) {
                text = StringUtils.substringAfter((String)text, (String)"{");
                text = StringUtils.substringBeforeLast((String)text, (String)"}");
                name = path.replace(File.separator, "");
                text = name + ": {\n" + (String)text + "\n}";
            } else {
                text = StringUtils.substringAfter((String)text, (String)"{");
                text = StringUtils.substringBeforeLast((String)text, (String)"}");
                text = StringUtils.substringBeforeLast((String)text, (String)"}");
                text = (String)text + "\n}\n";
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        MAP.put(name + "_" + fm, (String)text);
    }

    private static void recursionSet(Map<String, Object> structure, Map<String, Object> vm) {
        for (Map.Entry<String, Object> e : structure.entrySet()) {
            Object v = e.getValue();
            if (v instanceof String) {
                e.setValue(vm.get(e.getKey()));
                continue;
            }
            Map vnv = (Map)PojoUtil.cast((Object)vm.get(e.getKey()));
            I18nReadWrite.recursionSet((Map)PojoUtil.cast((Object)v), vnv);
        }
    }

    private static Function<I18nInfo, String> getFun(I18nTp tp) {
        return I18nReadWrite.i18nPair(tp).getFunInfo();
    }

    private static BiConsumer<I18nInfo, String> setFun(I18nTp tp) {
        return I18nReadWrite.i18nPair(tp).getConsInfo();
    }

    private static I18nSetGet i18nPair(I18nTp tp) {
        return (I18nSetGet)MapUtils.getObject(MAPPER, (Object)((Object)tp), (Object)MAPPER.get((Object)I18nTp.CN));
    }

    static {
        MAPPER.put(I18nTp.CN, new I18nSetGet(I18nInfo::getCn, I18nInfo::setCn, I18nName::setName));
        MAPPER.put(I18nTp.EN, new I18nSetGet(I18nInfo::getEn, I18nInfo::setEn, I18nName::setEnName));
        MAPPER.put(I18nTp.ES, new I18nSetGet(I18nInfo::getEs, I18nInfo::setEs, I18nName::setEsName));
        MAPPER.put(I18nTp.FR, new I18nSetGet(I18nInfo::getFr, I18nInfo::setFr, I18nName::setFrName));
        MAPPER.put(I18nTp.JA, new I18nSetGet(I18nInfo::getJa, I18nInfo::setJa, I18nName::setJaName));
    }
}

