/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.tool.util;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;

public class NotBlankChecker {
    private static final int MAX_LOOKAHEAD = 6;

    public static void checkProject(String path) {
        Path root = Paths.get(path, new String[0]);
        try (Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);){
            stream.filter(p -> p.toString().endsWith(".java")).forEach(NotBlankChecker::checkFile);
        }
        catch (Exception e) {
            System.err.println("\u274c checkProject \u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private static void checkFile(Path filePath) {
        try {
            List<String> lines = Files.readAllLines(filePath);
            block2: for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i).trim();
                if (!line.startsWith("@NotBlank")) continue;
                for (int j = 1; j <= 6 && i + j < lines.size(); ++j) {
                    String[] tokens;
                    String nextLine = lines.get(i + j).trim();
                    if (nextLine.isEmpty() || nextLine.startsWith("@")) continue;
                    if (!nextLine.matches("(private|protected|public)?\\s+[\\w<>\\[\\]]+\\s+\\w+\\s*;") || (tokens = nextLine.split("\\s+")).length < 3) continue block2;
                    String type = tokens[1];
                    String name = tokens[2].replace(";", "");
                    if ("String".equals(type)) continue block2;
                    System.out.printf("\u26a0\ufe0f  %s:%d - @NotBlank used on non-String field '%s' (type: %s)%n", filePath, i + j + 1, name, type);
                    continue block2;
                }
            }
        }
        catch (IOException e) {
            System.err.println("\u274c \u8bfb\u53d6\u5931\u8d25\uff1a" + String.valueOf(filePath));
        }
    }
}

