/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.tool;

import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.tool.model.JavaFileInfo;
import cn.sinozg.applet.tool.model.RepeatClassRequest;
import cn.sinozg.applet.tool.model.RepeatClassResponse;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatClassFile {
    public static final String SUFFIX = ".java";
    private static final AtomicInteger AI = new AtomicInteger(0);
    private static final Pattern PATTERN = Pattern.compile("message = \"\\{([^}]*)}\"");
    private static final Logger log = LoggerFactory.getLogger(RepeatClassFile.class);

    public static RepeatClassResponse absentClass(RepeatClassRequest params) throws IOException {
        File file = new File(params.getRootPath());
        RepeatClassResponse response = new RepeatClassResponse();
        TreeMap<String, JavaFileInfo> map = new TreeMap<String, JavaFileInfo>();
        RepeatClassFile.itemFile(map, file);
        int itemNum = 0;
        CharSequence[] defaultExistPackage = (String[])PojoUtil.toArray(params.getDefaultExistPackage(), String.class);
        CharSequence[] defaultExcludePackage = (String[])PojoUtil.toArray(params.getDefaultExcludePackage(), String.class);
        block0: for (Map.Entry e : map.entrySet()) {
            if (!Strings.CS.containsAny((CharSequence)e.getKey(), defaultExistPackage) || Strings.CS.containsAny((CharSequence)e.getKey(), defaultExcludePackage)) continue;
            ++itemNum;
            List<String> lines = ((JavaFileInfo)e.getValue()).getLines();
            if (CollectionUtils.isNotEmpty(lines)) {
                for (String line : lines) {
                    if (!Strings.CS.startsWithAny((CharSequence)line, new CharSequence[]{"@Component"})) continue;
                    continue block0;
                }
            }
            boolean exit = false;
            String ln = StringUtils.substringAfterLast((String)((String)e.getKey()), (String)".");
            String packageName = StringUtils.substringBeforeLast((String)((String)e.getKey()), (String)".");
            String importClazz = "import " + (String)e.getKey() + ";";
            for (Map.Entry om : map.entrySet()) {
                if (((String)om.getKey()).equals(e.getKey())) continue;
                if (((JavaFileInfo)om.getValue()).getContext().contains(importClazz)) {
                    exit = true;
                    break;
                }
                String pm = StringUtils.substringBeforeLast((String)((String)om.getKey()), (String)".");
                if (!packageName.equals(pm) || !Strings.CS.containsAny((CharSequence)((JavaFileInfo)om.getValue()).getContext(), new CharSequence[]{" " + ln + " ", "<" + ln + ">"})) continue;
                exit = true;
                break;
            }
            if (!exit) {
                response.addNonQuote((String)e.getKey());
            }
            RepeatClassFile.schema((String)e.getKey(), response);
        }
        response.setTotalFileSize(AI.get());
        response.setHandleFileSize(map.size());
        response.setJavaFileSize(itemNum);
        if (StringUtils.isNotBlank((CharSequence)params.getValidatorFile())) {
            RepeatClassFile.validator(map, params.getValidatorFile(), response);
        }
        return response;
    }

    private static void validator(Map<String, JavaFileInfo> map, String vpath, RepeatClassResponse response) {
        HashMap<String, String> vmap = new HashMap<String, String>();
        try {
            List<String> lines = FileUtils.readLines((File)new File(vpath), (Charset)Charset.defaultCharset());
            for (String line : lines) {
                if (!Strings.CS.contains((CharSequence)line, (CharSequence)"=")) continue;
                String[] kv = StringUtils.split((String)line, (String)"=");
                vmap.put(kv[0], kv[1]);
            }
            for (Map.Entry<String, JavaFileInfo> e : map.entrySet()) {
                JavaFileInfo info = e.getValue();
                lines = info.getLines();
                for (String line : lines) {
                    Matcher matcher = PATTERN.matcher(line);
                    if (!matcher.find()) continue;
                    String v = matcher.group(1);
                    vmap.remove(v);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry e : vmap.entrySet()) {
            response.addSurplusValidatorCode((String)e.getKey());
        }
    }

    private static void itemFile(Map<String, JavaFileInfo> map, File file) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    RepeatClassFile.itemFile(map, f);
                }
            }
        } else {
            String name = file.getAbsolutePath();
            if (Strings.CS.containsAny((CharSequence)name, new CharSequence[]{"target", ".git"})) {
                return;
            }
            AI.incrementAndGet();
            if (Strings.CS.endsWith((CharSequence)name, (CharSequence)SUFFIX)) {
                name = StringUtils.substringAfter((String)name, (String)(File.separator + "java" + File.separator));
                name = Strings.CS.replace(name, SUFFIX, "");
                name = Strings.CS.replace(name, File.separator, ".");
                JavaFileInfo fileInfo = new JavaFileInfo();
                List lines = FileUtils.readLines((File)file, (Charset)Charset.defaultCharset());
                fileInfo.setLines(lines);
                fileInfo.setContext(String.join((CharSequence)"", lines));
                map.put(name, fileInfo);
            }
        }
    }

    private static void schema(String name, RepeatClassResponse response) {
        if (Strings.CS.containsAny((CharSequence)name, new CharSequence[]{".handle.", ".service.", ".utils."})) {
            return;
        }
        try {
            String schemaName;
            Class<?> clazz = Class.forName(name);
            Schema schema = clazz.getAnnotation(Schema.class);
            if (schema != null && StringUtils.isNotBlank((CharSequence)(schemaName = schema.name())) && !Strings.CS.endsWith((CharSequence)name, (CharSequence)("." + schemaName))) {
                response.addDifferentSchema(name);
            }
        }
        catch (Exception e) {
            response.addErrorSchema(name + "<--->" + Arrays.toString(e.getStackTrace()));
        }
    }
}

