package cn.sinozg.applet.biz.system.mapper;

import cn.sinozg.applet.biz.system.entity.DictData;
import cn.sinozg.applet.biz.system.vo.request.DictDataPageRequest;
import cn.sinozg.applet.common.core.model.DictDataVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* 字典数据表 Mapper 接口
* @Description
* @Copyright Copyright (c) 2022
* @Author: xyb
* @since 2022-09-14 12:51:35
*/
public interface DictDataMapper extends BaseMapper<DictData> {

    /**
     * 查询缓存
     * @return 集合
     */
    List<DictDataVo> dictCache();
    /**
     * 分页查询
     * @param page 分页对象
     * @param params 请求参数
     * @return 分页
     */
    IPage<DictData> pageDictData(Page<DictData> page, @Param("p") DictDataPageRequest params);
}
