package cn.sinozg.applet.biz.system.service;

import cn.sinozg.applet.biz.system.entity.DictData;
import cn.sinozg.applet.biz.system.vo.request.DictDataPageRequest;
import cn.sinozg.applet.biz.system.vo.response.DictListResponse;
import cn.sinozg.applet.common.core.base.BaseResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import cn.sinozg.applet.common.core.model.DictDataVo;
import com.baomidou.mybatisplus.extension.service.IService;
import java.util.List;
import java.util.Map;

/**
 * 字典数据表 服务类
 *
 * @Author: xyb
 * @Description
 * @Copyright Copyright (c) 2022
 * @since 2022-09-14 12:51:35
 */
public interface DictDataService extends IService<DictData> {

    /**
     * 获取到所有的数据字典
     * @return 数据字典集合
     */
    Map<String, List<DictDataVo>> allDictCache();

    /**
     * 获取的某一个类型的数据字典
     * @param type 数据字典类型
     * @return 数据字典集合
     */
    List<DictListResponse> dictList(String type);

    /**
     * 分页查询
     * @param page 分页
     * @param request 请求参数
     * @return 分页返回结果
     */
    BaseResponse<List<DictData>> dictDataPage (PagingRequest page, DictDataPageRequest request);
}
