package cn.sinozg.applet.biz.system.service.impl;

import cn.sinozg.applet.biz.system.service.FrameworkLoginLogService;
import cn.sinozg.applet.biz.system.service.UserLoginOutService;
import cn.sinozg.applet.biz.system.vo.response.LoginAgentResponse;
import cn.sinozg.applet.common.constant.BaseConstants;
import cn.sinozg.applet.common.constant.BaseRedisKeys;
import cn.sinozg.applet.common.service.FrameworkAuthService;
import cn.sinozg.applet.common.utils.RedisUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-05 20:19
 */
@Service
public class UserLoginOutServiceImpl implements UserLoginOutService {

    @Resource
    private FrameworkLoginLogService frameworkLoginLogService;

    @Resource
    private FrameworkAuthService frameworkAuthService;
    @Override
    public void logout(String tokenId, String userId) {
        String message ;
        boolean force = false;
        // 本人登出
        if (StringUtils.isAllBlank(tokenId, userId)) {
            message = "本人登出！";
            tokenId = frameworkAuthService.tokenWithException();
            // 强制踢人下线
        } else {
            force = true;
            message = "强制踢掉！";
        }
        // uid
        if (StringUtils.isNotBlank(tokenId)) {
            userId = frameworkAuthService.loginIdByToken(tokenId);
        } else {
            tokenId = frameworkAuthService.tokenById(userId);
        }
        if (StringUtils.isAnyEmpty(userId, tokenId)) {
            return;
        }
        LoginAgentResponse agent = frameworkLoginLogService.browserInfo();
        // 记录日志
        frameworkLoginLogService.insertLoginInfo(agent, userId, null, BaseConstants.STATUS_01, true, message);
        // 删除掉 用户信息
        RedisUtil.deleteObject(String.format(BaseRedisKeys.USER_INFO, tokenId, userId));
        if (force) {
            frameworkAuthService.kickOutByTokenValue(tokenId);
        } else {
            frameworkAuthService.logout(tokenId);
        }

    }
}
