/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.biz.system.service.impl;

import cn.sinozg.applet.biz.framework.service.FrameworkUserLoginService;
import cn.sinozg.applet.common.core.model.LoginUserVo;
import cn.sinozg.applet.common.core.model.UserThreadInfo;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.holder.UserContextHolder;
import cn.sinozg.applet.common.service.FrameworkAuthService;
import cn.sinozg.applet.common.service.FrameworkUserService;
import cn.sinozg.applet.common.utils.RedisUtil;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FrameworkUserServiceImpl
implements FrameworkUserService {
    @Resource
    private FrameworkUserLoginService service;
    @Resource
    private FrameworkAuthService frameworkAuthService;
    private final Logger log = LoggerFactory.getLogger(FrameworkUserServiceImpl.class);

    public LoginUserVo refreshUserInfo() {
        return this.userInfo(true);
    }

    public LoginUserVo userInfo() {
        return this.userInfo(false);
    }

    public LoginUserVo setUserInfo(String token, String uid, LoginUserVo user) {
        if (user == null) {
            user = this.queryDb(uid);
        }
        String key = this.redisKey(token, uid);
        long timeout = this.frameworkAuthService.tokenTimeOut();
        RedisUtil.setCacheObject((String)key, (Object)user, (long)timeout);
        return user;
    }

    public LoginUserVo getUserInfo(String token, String uid) {
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{token, uid})) {
            String key = this.redisKey(token, uid);
            return (LoginUserVo)RedisUtil.getCacheObject((String)key);
        }
        return null;
    }

    private LoginUserVo userInfo(boolean force) {
        UserThreadInfo info;
        String token = this.frameworkAuthService.token();
        String uid = this.frameworkAuthService.loginId();
        if (StringUtils.isBlank((CharSequence)token) && (info = UserContextHolder.getInfo()) != null) {
            uid = info.getUid();
            token = info.getToken();
        }
        LoginUserVo user = null;
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{token, uid})) {
            String key = this.redisKey(token, uid);
            if (!force) {
                user = (LoginUserVo)RedisUtil.getCacheObject((String)key);
            }
            if (user == null && StringUtils.isNotBlank((CharSequence)uid)) {
                user = this.queryDb(uid);
                this.setUserInfo(token, uid, user);
            }
        }
        return user;
    }

    private LoginUserVo queryDb(String uid) {
        LoginUserVo user = this.service.userInfo(uid);
        if (user == null) {
            throw new CavException("BIZ000100002");
        }
        return user;
    }

    private String redisKey(String token, String uid) {
        return String.format("jby:biz:user_info:%s:%s", token, uid);
    }
}

