package cn.sinozg.applet.common.handler;

import cn.sinozg.applet.common.utils.TirsciUtil;
import cn.sinozg.applet.common.utils.UserUtil;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * mybatis plus 通用配置
 * @Author: X
 * @Description 填充器
 * @Date: 2022/6/19 21:42
 **/
@Component
public class MpMetaObjectHandler implements MetaObjectHandler {
    private static final String CREATE_TIME = "createdTime";
    private static final String CREATE_BY = "createdBy";
    private static final String UPDATE_TIME = "updatedTime";
    private static final String UPDATE_BY = "updatedBy";

    @Override
    public void insertFill(MetaObject mo) {
        // 创建时间
        this.strictInsertFill(mo, CREATE_TIME, LocalDateTime::now, LocalDateTime.class);
        this.strictInsertFill(mo, UPDATE_TIME, LocalDateTime::now, LocalDateTime.class);
        // 创建人
        String userName = getUserId();
        this.strictInsertFill(mo, CREATE_BY, () -> userName, String.class);
        this.strictInsertFill(mo, UPDATE_BY, () -> userName, String.class);


    }

    @Override
    public void updateFill(MetaObject mo) {
        // 更新时间
        this.strictUpdateFill(mo, UPDATE_TIME, LocalDateTime::now, LocalDateTime.class);
        // 更新人
        this.strictUpdateFill(mo, UPDATE_BY, this::getUserId, String.class);
    }

    private String getUserId() {
        return TirsciUtil.tryCatch(UserUtil::uid);
    }
}
