/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.biz.system.service.impl;

import cn.sinozg.applet.biz.system.entity.DictData;
import cn.sinozg.applet.biz.system.mapper.DictDataMapper;
import cn.sinozg.applet.biz.system.service.DictDataService;
import cn.sinozg.applet.biz.system.vo.request.DictDataPageRequest;
import cn.sinozg.applet.biz.system.vo.response.DictListResponse;
import cn.sinozg.applet.common.core.base.BaseResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import cn.sinozg.applet.common.core.model.DictDataVo;
import cn.sinozg.applet.common.enums.DictType;
import cn.sinozg.applet.common.utils.DictUtil;
import cn.sinozg.applet.common.utils.PageUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DictDataServiceImpl
extends ServiceImpl<DictDataMapper, DictData>
implements DictDataService {
    @Resource
    private DictDataMapper dictDataMapper;

    @Override
    public Map<String, List<DictDataVo>> allDictCache() {
        List<DictDataVo> list = this.dictDataMapper.dictCache();
        Map map = PojoUtil.groupMap(list, DictDataVo::getDictType);
        map.forEach((k, v) -> v.sort(Comparator.comparing(DictDataVo::getDictSort)));
        return map;
    }

    @Override
    public List<DictListResponse> dictList(String type) {
        List list = DictUtil.getDictCache((DictType)DictType.byCode((String)type));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.sort(Comparator.comparing(DictDataVo::getDictSort));
        }
        return PojoUtil.toList((Collection)list, d -> new DictListResponse(d.getDictValue(), d.getDictLabel()));
    }

    @Override
    public BaseResponse<List<DictData>> dictDataPage(PagingRequest page, DictDataPageRequest request) {
        PageUtil pu = (p, q) -> this.dictDataMapper.pageDictData((Page<DictData>)p, (DictDataPageRequest)q);
        return pu.page(page, (Object)request);
    }
}

