package cn.sinozg.applet.biz.system.entity;

import cn.sinozg.applet.common.core.base.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;

/**
* 系统访问记录表
* @Description
* @Copyright Copyright (c) 2022
* @Author: xyb
* @since 2022-09-16 12:02:41
*/
@TableName("sys_login_info")
@Schema(name = "LoginInfo", description = "系统访问记录")
public class LoginInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /** 访问ID */
    @Schema(description = "访问ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /** 用户账号 */
    @Schema(description = "用户账号")
    @TableField("user_name")
    private String userName;

    /** 登录的唯一信息 */
    @Schema(description = "登录的唯一信息")
    @TableField("login_key")
    private String loginKey;

    /** 登录IP地址 */
    @Schema(description = "登录IP地址")
    @TableField("ipaddr")
    private String ipaddr;

    /** 登录地点 */
    @Schema(description = "登录地点")
    @TableField("login_location")
    private String loginLocation;

    /** 浏览器类型 */
    @Schema(description = "浏览器类型")
    @TableField("browser")
    private String browser;

    /** 操作系统 */
    @Schema(description = "操作系统")
    @TableField("os")
    private String os;

    /** 提示消息 */
    @Schema(description = "提示消息")
    @TableField("msg")
    private String msg;
    /** 登录类型，00 登录，01登出 */
    @Schema(description = "登录类型，00 登录，01登出")
    @TableField("login_type")
    private String loginType;
    /** 访问时间 */
    @Schema(description = "访问时间")
    @TableField("login_time")
    private LocalDateTime loginTime;

    /** 登录状态;0成功 1失败 */
    @Schema(description = "登录状态;0成功 1失败")
    @TableField("data_status")
    private String dataStatus;

    /** 租户id */
    @Schema(description = "租户id")
    @TableField("tenant_id")
    private String tenantId;

    /**
     * 获取 访问ID
     *
     * @return id 访问ID
     */
    public String getId() {
        return this.id;
    }

    /**
     * 设置 访问ID
     *
     * @param id 访问ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取 用户账号
     *
     * @return userName 用户账号
     */
    public String getUserName() {
        return this.userName;
    }

    /**
     * 设置 用户账号
     *
     * @param userName 用户账号
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getLoginKey() {
        return loginKey;
    }

    public void setLoginKey(String loginKey) {
        this.loginKey = loginKey;
    }

    /**
     * 获取 登录IP地址
     *
     * @return ipaddr 登录IP地址
     */
    public String getIpaddr() {
        return this.ipaddr;
    }

    /**
     * 设置 登录IP地址
     *
     * @param ipaddr 登录IP地址
     */
    public void setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
    }

    /**
     * 获取 登录地点
     *
     * @return loginLocation 登录地点
     */
    public String getLoginLocation() {
        return this.loginLocation;
    }

    /**
     * 设置 登录地点
     *
     * @param loginLocation 登录地点
     */
    public void setLoginLocation(String loginLocation) {
        this.loginLocation = loginLocation;
    }

    /**
     * 获取 浏览器类型
     *
     * @return browser 浏览器类型
     */
    public String getBrowser() {
        return this.browser;
    }

    /**
     * 设置 浏览器类型
     *
     * @param browser 浏览器类型
     */
    public void setBrowser(String browser) {
        this.browser = browser;
    }

    /**
     * 获取 操作系统
     *
     * @return os 操作系统
     */
    public String getOs() {
        return this.os;
    }

    /**
     * 设置 操作系统
     *
     * @param os 操作系统
     */
    public void setOs(String os) {
        this.os = os;
    }

    /**
     * 获取 提示消息
     *
     * @return msg 提示消息
     */
    public String getMsg() {
        return this.msg;
    }

    /**
     * 设置 提示消息
     *
     * @param msg 提示消息
     */
    public void setMsg(String msg) {
        this.msg = msg;
    }

    /**
     * 获取 登录类型，00 登录，01登出
     *
     * @return loginType 登录类型，00 登录，01登出
     */
    public String getLoginType() {
        return this.loginType;
    }

    /**
     * 设置 登录类型，00 登录，01登出
     *
     * @param loginType 登录类型，00 登录，01登出
     */
    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    /**
     * 获取 访问时间
     *
     * @return loginTime 访问时间
     */
    public LocalDateTime getLoginTime() {
        return this.loginTime;
    }

    /**
     * 设置 访问时间
     *
     * @param loginTime 访问时间
     */
    public void setLoginTime(LocalDateTime loginTime) {
        this.loginTime = loginTime;
    }

    /**
     * 获取 登录状态;0成功 1失败
     *
     * @return dataStatus 登录状态;0成功 1失败
     */
    public String getDataStatus() {
        return this.dataStatus;
    }

    /**
     * 设置 登录状态;0成功 1失败
     *
     * @param dataStatus 登录状态;0成功 1失败
     */
    public void setDataStatus(String dataStatus) {
        this.dataStatus = dataStatus;
    }

    /**
     * 获取 租户id
     *
     * @return tenantId 租户id
     */
    public String getTenantId() {
        return this.tenantId;
    }

    /**
     * 设置 租户id
     *
     * @param tenantId 租户id
     */
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
}
