package cn.sinozg.applet.common.handler;

import cn.sinozg.applet.common.constant.BaseConstants;
import cn.sinozg.applet.common.core.base.BaseResponse;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.MsgUtil;
import cn.sinozg.applet.common.utils.VerifyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import javax.servlet.http.HttpServletRequest;

/**
* 全局异常处理器
* @Author: xyb
* @Description: 
* @Date: 2022-11-14 下午 10:10
**/
@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    /**
     * 在controller里面内容执行之前，
     * 校验一些参数不匹配啊，
     * Get post方法不对啊之类的
     * @param request HttpServletRequest
     * @param e 异常
     * @return 结果集
     */
    @ResponseBody
    @ExceptionHandler(Exception.class)
    public BaseResponse<String> jsonHandler(HttpServletRequest request, Exception e) {
        log.error("GlobalExceptionHandler.jsonHandler start");
        return MsgUtil.error(request, e, BaseConstants.GLOBAL_EXCEPTION_MESSAGE);
    }
    /**
     * 业务异常处理
     * @param request HttpServletRequest
     * @param e 异常
     * @return 结果集
     */
    @ResponseBody
    @ExceptionHandler(CavException.class)
    public BaseResponse<String> cavException(HttpServletRequest request, CavException e) {
        log.error("business exception start");
        return MsgUtil.error(request, e, e.getCode(), e.getParameters());

    }

    /**
     * 请求参数异常处理
     * @param request HttpServletRequest
     * @param e 异常
     * @return 结果集
     */
    @ResponseBody
    @ExceptionHandler(MethodArgumentNotValidException.class)
    public BaseResponse<String> argumentNotValidException(HttpServletRequest request, MethodArgumentNotValidException e) {
        log.error("MethodArgumentNotValidException start");
        String msg = VerifyUtil.errorInfo(e.getBindingResult());
        return MsgUtil.error(request, e, "BIZ000100014", msg);
    }
}
