package cn.sinozg.applet.biz.system.mapper;

import cn.sinozg.applet.biz.system.entity.LoginInfo;
import cn.sinozg.applet.biz.system.vo.request.LoginInfoPageListRequest;
import cn.sinozg.applet.biz.system.vo.response.LoginInfoPageListResponse;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* 系统访问记录 Mapper 接口
* @Description
* @Copyright Copyright (c) 2022
* @Author: xyb
* @since 2022-09-14 12:51:35
*/
public interface LoginInfoMapper extends BaseMapper<LoginInfo> {

    /**
     * 查询系统登录日志集合
     * @param page 分页
     * @param loginInfo 访问日志对象
     * @return 登录记录集合
     */
    IPage<LoginInfoPageListResponse> selectLoginInfoPage(Page<LoginInfoPageListResponse> page, @Param("p") LoginInfoPageListRequest loginInfo);

    /**
     * 查询登陆日志
     * @param loginInfo 查询参数
     * @return 登录日志
     */
    List<LoginInfoPageListResponse> list(@Param("p") LoginInfoPageListRequest loginInfo);

    /**
     * 清空系统登录日志
     *
     * @return 结果
     */
    int cleanLoginInfo();
}
