package cn.sinozg.applet.biz.system.service.impl;

import cn.sinozg.applet.biz.system.entity.LoginInfo;
import cn.sinozg.applet.biz.system.mapper.LoginInfoMapper;
import cn.sinozg.applet.biz.system.service.FrameworkLoginLogService;
import cn.sinozg.applet.biz.system.service.LoginInfoService;
import cn.sinozg.applet.biz.system.vo.request.LoginInfoPageListRequest;
import cn.sinozg.applet.biz.system.vo.response.LoginAgentResponse;
import cn.sinozg.applet.biz.system.vo.response.LoginInfoPageListResponse;
import cn.sinozg.applet.common.constant.BaseConstants;
import cn.sinozg.applet.common.core.base.BasePageResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import cn.sinozg.applet.common.core.model.UserAgentInfo;
import cn.sinozg.applet.common.utils.OsUtil;
import cn.sinozg.applet.common.utils.PageUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 系统访问记录 服务实现类
 *
 * @Author: xyb
 * @Description
 * @Copyright Copyright (c) 2022
 * @since 2022-09-14 12:51:35
 */
@Service
public class LoginInfoServiceImpl extends ServiceImpl<LoginInfoMapper, LoginInfo> implements LoginInfoService, FrameworkLoginLogService {

    @Resource
    private LoginInfoMapper loginInfoMapper;

    private final Logger log = LoggerFactory.getLogger(LoginInfoServiceImpl.class);

    @Override
    public LoginAgentResponse browserInfo() {
        HttpServletRequest request = WebUtil.request();
        UserAgentInfo userAgent = OsUtil.userAgent(request);
        String ip = OsUtil.getIpAddr(request);
        LoginAgentResponse response = new LoginAgentResponse();
        response.setAgent(userAgent);
        response.setIp(ip);
        return response;
    }

    /**
     * 新增系统登录日志
     *
     */
    @Override
    public void insertLoginInfo(LoginAgentResponse agent, final String username, final String loginKey, final String type, final boolean success, final String message) {
        String ip = agent.getIp();
        String address = OsUtil.realAddressByIp(ip);
        UserAgentInfo info = agent.getAgent();
        log.info("ip {}， address {}，username {}， loginKey{},  status {}，message {}", ip, address, username, loginKey, success, message);
        // 封装对象
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setUserName(username);
        loginInfo.setLoginKey(StringUtils.substring(loginKey, 0, 200));
        loginInfo.setIpaddr(ip);
        loginInfo.setLoginLocation(address);
        loginInfo.setBrowser(info.getBrowser());
        loginInfo.setOs(info.getPlatform());
        loginInfo.setMsg(message);
        // 日志状态
        loginInfo.setLoginTime(LocalDateTime.now());
        loginInfo.setLoginType(type);
        loginInfo.setDataStatus(success ? BaseConstants.STATUS_COMMON : BaseConstants.STATUS_STOP);
        loginInfoMapper.insert(loginInfo);
    }

    /**
     * 查询系统登录日志集合
     *
     * @param loginInfo 访问日志对象
     * @return 登录记录集合
     */
    @Override
    public BasePageResponse<List<LoginInfoPageListResponse>> selectLoginInfoPage(PagingRequest page, LoginInfoPageListRequest loginInfo) {
        PageUtil<LoginInfoPageListResponse, LoginInfoPageListRequest> pu = (p, q) -> loginInfoMapper.selectLoginInfoPage(p, q);
        return pu.page(page, loginInfo);
    }

    @Override
    public List<LoginInfoPageListResponse> list(LoginInfoPageListRequest loginInfo) {
        return loginInfoMapper.list(loginInfo);
    }

    /**
     * 批量删除系统登录日志
     *
     * @param infoIds 需要删除的登录日志ID
     * @return 删除成功条数
     */
    @Override
    public int deleteLoginInfoByIds(List<String> infoIds) {
        return loginInfoMapper.deleteByIds(infoIds);
    }

    /**
     * 清空系统登录日志
     */
    @Override
    public void cleanLoginInfo() {
        loginInfoMapper.cleanLoginInfo();
    }
}
