package cn.sinozg.applet.biz.system.vo.request;

import io.swagger.v3.oas.annotations.media.Schema;

/**
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-21 上午 10:51
 **/
public class LoginInfoPageListRequest {

    /** 登录IP地址 */
    @Schema(description = "登录IP地址")
    private String ipaddr;

    /** 操作状态;00正常 01异常 */
    @Schema(description = "操作状态;00正常 01异常")
    private String dataStatus;
    /** 登录类型，00 登录，01登出 */
    @Schema(description = "登录类型，00 登录，01登出")
    private String loginType;
    /** 用户账号 */
    @Schema(description = "用户账号")
    private String userName;
    /** 开始时间 */
    @Schema(description = "开始时间 yyyy-MM-dd")
    private String beginTime;
    /** 结束时间 */
    @Schema(description = "结束时间 yyyy-MM-dd")
    private String endTime;

    /**
     * 获取 登录IP地址
     *
     * @return ipaddr 登录IP地址
     */
    public String getIpaddr() {
        return this.ipaddr;
    }

    /**
     * 设置 登录IP地址
     *
     * @param ipaddr 登录IP地址
     */
    public void setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
    }

    /**
     * 获取 操作状态;00正常 01异常
     *
     * @return dataStatus 操作状态;00正常 01异常
     */
    public String getDataStatus() {
        return this.dataStatus;
    }

    /**
     * 设置 操作状态;00正常 01异常
     *
     * @param dataStatus 操作状态;00正常 01异常
     */
    public void setDataStatus(String dataStatus) {
        this.dataStatus = dataStatus;
    }

    /**
     * 获取 登录类型，00 登录，01登出
     *
     * @return loginType 登录类型，00 登录，01登出
     */
    public String getLoginType() {
        return this.loginType;
    }

    /**
     * 设置 登录类型，00 登录，01登出
     *
     * @param loginType 登录类型，00 登录，01登出
     */
    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    /**
     * 获取 用户账号
     *
     * @return userName 用户账号
     */
    public String getUserName() {
        return this.userName;
    }

    /**
     * 设置 用户账号
     *
     * @param userName 用户账号
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * 获取 开始时间
     *
     * @return beginTime 开始时间
     */
    public String getBeginTime() {
        return this.beginTime;
    }

    /**
     * 设置 开始时间
     *
     * @param beginTime 开始时间
     */
    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    /**
     * 获取 结束时间
     *
     * @return endTime 结束时间
     */
    public String getEndTime() {
        return this.endTime;
    }

    /**
     * 设置 结束时间
     *
     * @param endTime 结束时间
     */
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }
}