package cn.sinozg.applet.common.handler;

import cn.sinozg.applet.common.config.SystemConfig;
import cn.sinozg.applet.common.core.model.UserThreadInfo;
import cn.sinozg.applet.common.holder.UserContextHolder;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * 多租户 配置
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-26 下午 04:41
 **/
public class TenantHandler implements TenantLineHandler {
    private final Logger log = LoggerFactory.getLogger(TenantHandler.class);
    @Override
    public Expression getTenantId() {
        UserThreadInfo info = UserContextHolder.getInfo();
        if (info == null) {
            if (log.isWarnEnabled()) {
                log.warn("租户信息为空！");
            }
            return new StringValue();
        }
        return new StringValue(info.getTenantId());
    }

    @Override
    public boolean ignoreTable(String tableName) {
        List<String> tenantTables = SystemConfig.APP.getTenant().getTables();
        return CollectionUtils.isEmpty(tenantTables) || CollectionUtils.containsAny(tenantTables, tableName.toLowerCase());
    }
}