/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.biz.system.service.impl;

import cn.sinozg.applet.biz.system.entity.LoginInfo;
import cn.sinozg.applet.biz.system.mapper.LoginInfoMapper;
import cn.sinozg.applet.biz.system.service.FrameworkLoginLogService;
import cn.sinozg.applet.biz.system.service.LoginInfoService;
import cn.sinozg.applet.biz.system.vo.request.LoginInfoPageListRequest;
import cn.sinozg.applet.biz.system.vo.response.LoginAgentResponse;
import cn.sinozg.applet.biz.system.vo.response.LoginInfoPageListResponse;
import cn.sinozg.applet.common.core.base.BasePageResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import cn.sinozg.applet.common.core.model.UserAgentInfo;
import cn.sinozg.applet.common.utils.OsUtil;
import cn.sinozg.applet.common.utils.PageUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoginInfoServiceImpl
extends ServiceImpl<LoginInfoMapper, LoginInfo>
implements LoginInfoService,
FrameworkLoginLogService {
    @Resource
    private LoginInfoMapper loginInfoMapper;
    private final Logger log = LoggerFactory.getLogger(LoginInfoServiceImpl.class);

    public LoginAgentResponse browserInfo() {
        HttpServletRequest request = WebUtil.request();
        UserAgentInfo userAgent = OsUtil.userAgent((HttpServletRequest)request);
        String ip = OsUtil.getIpAddr((HttpServletRequest)request);
        LoginAgentResponse response = new LoginAgentResponse();
        response.setAgent(userAgent);
        response.setIp(ip);
        return response;
    }

    public void insertLoginInfo(LoginAgentResponse agent, String username, String loginKey, String type, boolean success, String message) {
        String ip = agent.getIp();
        String address = OsUtil.realAddressByIp((String)ip);
        UserAgentInfo info = agent.getAgent();
        this.log.info("ip {}\uff0c address {}\uff0cusername {}\uff0c loginKey{},  status {}\uff0cmessage {}", new Object[]{ip, address, username, loginKey, success, message});
        LoginInfo loginInfo = new LoginInfo();
        loginInfo.setUserName(username);
        loginInfo.setLoginKey(StringUtils.substring((String)loginKey, (int)0, (int)200));
        loginInfo.setIpaddr(ip);
        loginInfo.setLoginLocation(address);
        loginInfo.setBrowser(info.getBrowser());
        loginInfo.setOs(info.getPlatform());
        loginInfo.setMsg(message);
        loginInfo.setLoginTime(LocalDateTime.now());
        loginInfo.setLoginType(type);
        loginInfo.setDataStatus(success ? "00" : "01");
        this.loginInfoMapper.insert((Object)loginInfo);
    }

    @Override
    public BasePageResponse<List<LoginInfoPageListResponse>> selectLoginInfoPage(PagingRequest page, LoginInfoPageListRequest loginInfo) {
        PageUtil pu = (p, q) -> this.loginInfoMapper.selectLoginInfoPage((Page<LoginInfoPageListResponse>)p, (LoginInfoPageListRequest)q);
        return pu.page(page, (Object)loginInfo);
    }

    @Override
    public List<LoginInfoPageListResponse> list(LoginInfoPageListRequest loginInfo) {
        return this.loginInfoMapper.list(loginInfo);
    }

    @Override
    public int deleteLoginInfoByIds(List<String> infoIds) {
        return this.loginInfoMapper.deleteByIds(infoIds);
    }

    @Override
    public void cleanLoginInfo() {
        this.loginInfoMapper.cleanLoginInfo();
    }
}

