package cn.sinozg.applet.common.config;

import cn.sinozg.applet.common.constant.BaseConstants;
import cn.sinozg.applet.common.i18n.AppletLocaleResolver;
import cn.sinozg.applet.common.utils.PojoUtil;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

import javax.validation.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
* 国际化配置
* @Author: xyb
* @Description:
* @Date: 2023-03-26 下午 08:48
**/
@Configuration
@ConfigurationProperties(prefix = "spring.messages")
public class I8nConfig {

    private List<String> basename;

    private String encoding;

    @Bean
    public MessageSource messageSource(){
        ResourceBundleMessageSource source = new ResourceBundleMessageSource();
        source.setBasenames(PojoUtil.toArray(basename, String.class));
        source.setDefaultEncoding(encoding);
        return source;
    }

    @Bean
    public Validator validator(){
        LocalValidatorFactoryBean factory = new LocalValidatorFactoryBean();
        factory.setValidationMessageSource(messageSource());
        return factory;
    }

    @Bean(name = BaseConstants.LOCALE_RESOLVER)
    public AppletLocaleResolver resolver(){
        AppletLocaleResolver resolver = new AppletLocaleResolver();
        resolver.setDefaultLocale(Locale.CHINA);
        List<Locale> locales = new ArrayList<>();
        locales.add(Locale.CHINA);
        locales.add(Locale.US);
        resolver.setSupportLocales(locales);
        return resolver;
    }

    public void setBasename(List<String> basename) {
        this.basename = basename;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}
