/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.filter;

import cn.sinozg.applet.common.filter.WrapperRequest;
import cn.sinozg.applet.common.holder.MdcContextHolder;
import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.utils.SpringUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerExceptionResolver;

public class WrapperFilter
implements Filter {
    private AppValue app;
    private final Logger log = LoggerFactory.getLogger(WrapperFilter.class);

    public WrapperFilter() {
    }

    public WrapperFilter(AppValue app) {
        this.app = app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object servletRequest = null;
        try {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest hsr = (HttpServletRequest)request;
                String traceId = hsr.getHeader("Whj-Trace-Id");
                MdcContextHolder.put((String)traceId);
                boolean isWrapper = this.app.getApiUrl().isWrapperEnable();
                if (isWrapper) {
                    String contentType = StringUtils.substringBefore((String)request.getContentType(), (String)";");
                    isWrapper = StringUtils.equalsAnyIgnoreCase((CharSequence)contentType, (CharSequence[])new CharSequence[]{"application/json", "application/json; charset=utf-8"});
                }
                if (isWrapper) {
                    try {
                        servletRequest = new WrapperRequest(hsr, response, this.app.getSign());
                    }
                    catch (Exception e) {
                        HandlerExceptionResolver resolver = (HandlerExceptionResolver)SpringUtil.getBean((String)"handlerExceptionResolver");
                        resolver.resolveException(hsr, (HttpServletResponse)response, null, (Exception)new RuntimeException("Decryption parameter exception!"));
                        MdcContextHolder.clear();
                        return;
                    }
                }
            }
            if (servletRequest == null) {
                servletRequest = request;
            }
            chain.doFilter(servletRequest, response);
        }
        finally {
            MdcContextHolder.clear();
        }
    }
}

